/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.neoforge.platform;

import java.util.function.Supplier;
import mod.azure.azurelib.common.platform.services.CommonRegistry;
import mod.azure.azurelib.neoforge.NeoForgeAzureLibMod;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class NeoForgeCommonRegistry
implements CommonRegistry {
    @Override
    public <T> Supplier<T> register(Registry<? super T> registry, String registryName, Supplier<? extends T> supplier) {
        if (registry == BuiltInRegistries.BLOCK) {
            return NeoForgeAzureLibMod.blockDeferredRegister.register(registryName, supplier);
        }
        if (registry == BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            return NeoForgeAzureLibMod.blockEntityTypeDeferredRegister.register(registryName, supplier);
        }
        throw new IllegalArgumentException("Received registration attempt for an unhandled registry. Registry: " + String.valueOf(registry));
    }

    @Override
    public <E extends Mob> Supplier<SpawnEggItem> makeSpawnEggFor(Supplier<EntityType<E>> entityType, int primaryEggColour, int secondaryEggColour, Item.Properties itemProperties) {
        return () -> new DeferredSpawnEggItem(entityType, primaryEggColour, secondaryEggColour, itemProperties);
    }

    @Override
    public CreativeModeTab.Builder newCreativeTabBuilder() {
        return CreativeModeTab.builder();
    }
}

