/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.block;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelib.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityModelRenderer;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererPipeline;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Deprecated(since="3.0.30", forRemoval=true)
public abstract class AzDynamicBlockEntityModelRenderer<T extends BlockEntity>
extends AzBlockEntityModelRenderer<T> {
    public AzDynamicBlockEntityModelRenderer(AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(blockEntityRendererPipeline, layerRenderer);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        BlockEntity entity = (BlockEntity)context.animatable();
        PoseStack poseStack = context.poseStack();
        RenderType renderType = context.renderType();
        poseStack.pushPose();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, Vec3.ZERO.toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), new Vector3f((float)entity.getBlockPos().getX(), (float)entity.getBlockPos().getY(), (float)entity.getBlockPos().getZ())));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        AzRendererConfig<BlockEntity> config = this.blockEntityRendererPipeline.config();
        context.setTextureOverride(this.getTextureOverrideForBone(bone, (BlockEntity)context.animatable(), context.partialTick()));
        ResourceLocation texture = context.getTextureOverride() == null ? config.textureLocation((BlockEntity)context.animatable()) : context.getTextureOverride();
        RenderType renderTypeOverride = this.getRenderTypeOverrideForBone(bone, (BlockEntity)context.animatable(), texture, bufferSource, context.partialTick());
        if (texture != null && renderTypeOverride == null) {
            renderType = renderTypeOverride = context.getDefaultRenderType((BlockEntity)context.animatable(), texture, context.multiBufferSource(), context.partialTick());
        }
        if (renderTypeOverride != null) {
            context.setVertexConsumer(bufferSource.getBuffer(renderTypeOverride));
            renderType = renderTypeOverride;
        }
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.renderColor())) {
            super.renderCubesOfBone(context, bone);
        }
        if (!isReRender && buffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)buffer;
            if (!builder.building) {
                context.setVertexConsumer(bufferSource.getBuffer(renderType));
            }
        }
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.popPose();
    }

    @Override
    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        if (context.getTextureOverride() == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        AzRendererConfig<BlockEntity> config = this.blockEntityRendererPipeline.config();
        IntIntPair boneTextureSize = context.computeTextureSize(context.getTextureOverride());
        IntIntPair entityTextureSize = context.computeTextureSize(config.textureLocation((BlockEntity)context.animatable()));
        if (boneTextureSize == null || entityTextureSize == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        for (GeoVertex vertex : quad.vertices()) {
            Vector4f vector4f = poseState.transform(new Vector4f(vertex.position().x(), vertex.position().y(), vertex.position().z(), 1.0f));
            float texU = vertex.texU() * (float)entityTextureSize.firstInt() / (float)boneTextureSize.firstInt();
            float texV = vertex.texV() * (float)entityTextureSize.secondInt() / (float)boneTextureSize.secondInt();
            context.vertexConsumer().addVertex(vector4f.x(), vector4f.y(), vector4f.z(), -1, texU, texV, context.packedOverlay(), context.packedLight(), normal.x(), normal.y(), normal.z());
        }
    }
}

