/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzEntityRendererPipelineContext<T extends Entity>
extends AzRendererPipelineContext<T> {
    public AzEntityRendererPipelineContext(AzRendererPipeline<T> rendererPipeline) {
        super(rendererPipeline);
    }

    @Override
    @NotNull
    public RenderType getDefaultRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        boolean isInvisible = animatable.isInvisible();
        boolean isPlayerInvisible = animatable.isInvisibleTo(ClientUtils.getClientPlayer());
        if (isInvisible) {
            if (!isPlayerInvisible) {
                return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
            }
            return null;
        }
        if (Minecraft.getInstance().shouldEntityAppearGlowing(animatable)) {
            return RenderType.outline((ResourceLocation)texture);
        }
        return RenderType.entityTranslucentCull((ResourceLocation)texture);
    }

    @Override
    public int getPackedOverlay(T entity, float u, float partialTick) {
        if (!(entity instanceof LivingEntity)) {
            return OverlayTexture.NO_OVERLAY;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return OverlayTexture.pack((int)OverlayTexture.u((float)u), (int)OverlayTexture.v((livingEntity.hurtTime > 0 || livingEntity.deathTime > 0 ? 1 : 0) != 0));
    }
}

