/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipeline;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzItemModelRenderer
extends AzModelRenderer<ItemStack> {
    protected final AzItemRendererPipeline itemRendererPipeline;

    public AzItemModelRenderer(AzItemRendererPipeline itemRendererPipeline, AzLayerRenderer<ItemStack> layerRenderer) {
        super(itemRendererPipeline, layerRenderer);
        this.itemRendererPipeline = itemRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        if (!isReRender) {
            ItemStack animatable = context.animatable();
            AzItemAnimator animator = this.itemRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                this.handleAnimation(animator, animatable, context.partialTick());
            }
        }
        PoseStack poseStack = context.poseStack();
        this.itemRendererPipeline.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<ItemStack> context, AzBone bone, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        if (bone.isTrackingMatrices()) {
            ItemStack animatable = context.animatable();
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.itemRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset(animatable, 1.0f).toVector3f()));
        }
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context));
        super.renderRecursively(context, bone, isReRender);
        poseStack.popPose();
    }

    public Vec3 getRenderOffset(ItemStack itemStack, float f) {
        return Vec3.ZERO;
    }
}

