/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.UUID;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.rewrite.render.item.AzItemRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin_AzItemIDFix {
    @Unique
    private static final int DEFAULT_AZ_ID = -1;

    @Redirect(method={"doClick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;copyWithCount(I)Lnet/minecraft/world/item/ItemStack;", ordinal=1))
    public ItemStack azurelib$syncAzureIDWithRemote(ItemStack itemStack, int count) {
        ItemStack copyStack = itemStack.m_255036_(count);
        AzItemRenderer itemRenderer = AzItemRendererRegistry.getOrNull(itemStack.m_41720_());
        AzArmorRenderer armorRenderer = AzArmorRendererRegistry.getOrNull(itemStack.m_41720_());
        if ((itemRenderer != null || armorRenderer != null) && copyStack.m_41782_()) {
            copyStack.m_41784_().m_128473_("az_id");
            copyStack.m_41784_().m_128362_("az_id", UUID.randomUUID());
        }
        return copyStack;
    }

    @WrapOperation(method={"synchronizeSlotToRemote"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean azurelib$syncAzureIDWithRemote(ItemStack itemStack, ItemStack comparisonItemStack, Operation<Boolean> original) {
        return this.azurelib$compareStacksWithAzureID(itemStack, comparisonItemStack, original);
    }

    @WrapOperation(method={"triggerSlotListeners"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean azurelib$detectSlotChangeWithAzureID(ItemStack itemStack, ItemStack comparisonItemStack, Operation<Boolean> original) {
        return this.azurelib$compareStacksWithAzureID(itemStack, comparisonItemStack, original);
    }

    @Unique
    private boolean azurelib$compareStacksWithAzureID(ItemStack itemStack, ItemStack comparisonItemStack, Operation<Boolean> original) {
        AzItemRenderer itemRenderer = AzItemRendererRegistry.getOrNull(itemStack.m_41720_());
        AzArmorRenderer armorRenderer = AzArmorRendererRegistry.getOrNull(itemStack.m_41720_());
        if (itemRenderer == null && armorRenderer == null) {
            return (Boolean)original.call(new Object[]{itemStack, comparisonItemStack});
        }
        return (Boolean)original.call(new Object[]{itemStack, comparisonItemStack}) != false && AbstractContainerMenuMixin_AzItemIDFix.azurelib$checkAzIDMatch(itemStack.m_41783_(), comparisonItemStack.m_41783_());
    }

    @Unique
    private static boolean azurelib$checkAzIDMatch(CompoundTag tag1, CompoundTag tag2) {
        return (tag1 == null ? -1 : tag1.m_128451_("az_id")) == (tag2 == null ? -1 : tag2.m_128451_("az_id"));
    }
}

