/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzEntityModelRenderer<T extends Entity>
extends AzModelRenderer<T> {
    protected final AzEntityRendererPipeline<T> entityRendererPipeline;

    public AzEntityModelRenderer(AzEntityRendererPipeline<T> entityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(entityRendererPipeline, layerRenderer);
        this.entityRendererPipeline = entityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        AzEntityAnimator<T> animator;
        float f;
        LivingEntity livingEntity;
        Direction bedDirection;
        Entity animatable = (Entity)context.animatable();
        float partialTick = context.partialTick();
        PoseStack poseStack = context.poseStack();
        poseStack.m_85836_();
        float lerpBodyRot = AzEntityModelRenderer.getLerpRot(animatable, partialTick);
        if (animatable.m_20089_() == Pose.SLEEPING && animatable instanceof LivingEntity && (bedDirection = (livingEntity = (LivingEntity)animatable).m_21259_()) != null) {
            float eyePosOffset = livingEntity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-bedDirection.m_122429_()) * eyePosOffset, 0.0f, (float)(-bedDirection.m_122431_()) * eyePosOffset);
        }
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)animatable;
            f = livingEntity2.m_6134_();
        } else {
            f = 1.0f;
        }
        float nativeScale = f;
        float ageInTicks = (float)animatable.f_19797_ + partialTick;
        poseStack.m_85841_(nativeScale, nativeScale, nativeScale);
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
        if (!isReRender && (animator = this.entityRendererPipeline.getRenderer().getAnimator()) != null) {
            this.handleAnimation(animator, animatable, context.partialTick());
        }
        this.entityRendererPipeline.modelRenderTranslations.set((Matrix4fc)poseStack.m_85850_().m_252922_());
        if (!animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            super.render(context, isReRender);
        }
        poseStack.m_85849_();
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        Entity entity = (Entity)context.animatable();
        PoseStack poseStack = context.poseStack();
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.entityRendererPipeline.getRenderer().m_7860_(entity, 1.0f).m_252839_()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), entity.m_20182_().m_252839_()));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context));
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.m_85849_();
    }

    private static <T extends Entity> float getLerpRot(T animatable, float partialTick) {
        Entity entity;
        float lerpHeadRot;
        float lerpBodyRot;
        boolean shouldSit;
        boolean bl = shouldSit = animatable.m_20159_() && animatable.m_20202_() != null;
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            v1 = Mth.m_14189_((float)partialTick, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
        } else {
            v1 = lerpBodyRot = animatable.m_146908_();
        }
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            v2 = Mth.m_14189_((float)partialTick, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
        } else {
            v2 = lerpHeadRot = animatable.m_6080_();
        }
        if (shouldSit && (entity = animatable.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            float netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
        }
        return lerpBodyRot;
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        this.applyRotations(animatable, poseStack, ageInTicks, rotationYaw, partialTick, 1.0f);
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (animatable.m_146890_()) {
            rotationYaw += (float)(Math.cos((double)((Entity)animatable).f_19797_ * 3.25) * Math.PI * 0.4);
        }
        if (!animatable.m_217003_(Pose.SLEEPING)) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
        }
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)animatable;
            AzEntityRendererConfig<T> config = this.entityRendererPipeline.getRenderer().config();
            float deathMaxRotation = config.getDeathMaxRotation(animatable);
            if (livingEntity.f_20919_ > 0) {
                float deathRotation = ((float)livingEntity.f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.m_252781_(Axis.f_252403_.m_252977_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * deathMaxRotation));
            } else if (livingEntity.m_21209_()) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - livingEntity.m_146909_()));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)livingEntity.f_19797_ + partialTick) * -75.0f));
            } else if (animatable.m_217003_(Pose.SLEEPING)) {
                Direction bedOrientation = livingEntity.m_21259_();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(deathMaxRotation));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            } else if (LivingEntityRenderer.m_194453_((LivingEntity)livingEntity)) {
                poseStack.m_252880_(0.0f, (animatable.m_20206_() + 0.1f) / nativeScale, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            }
        }
    }
}

