/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.platform.services.AzureLibNetwork;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AzBlockEntityDispatchCommandPacket
extends AbstractPacket {
    private final BlockPos blockPos;
    private final AzCommand dispatchCommand;

    public AzBlockEntityDispatchCommandPacket(BlockPos blockPos, AzCommand dispatchCommand) {
        this.blockPos = blockPos;
        this.dispatchCommand = dispatchCommand;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        AzCommand.ENCODER.accept(buf, this.dispatchCommand);
    }

    @Override
    public ResourceLocation getPacketID() {
        return AzureLibNetwork.AZ_BLOCKENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID;
    }

    public static AzBlockEntityDispatchCommandPacket receive(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.m_130135_();
        AzCommand dispatchCommand = AzCommand.DECODER.apply(buf);
        return new AzBlockEntityDispatchCommandPacket(blockPos, dispatchCommand);
    }

    @Override
    public void handle() {
        BlockEntity blockEntity = ClientUtils.getLevel().m_7702_(this.blockPos);
        if (blockEntity == null) {
            return;
        }
        AzAnimator<BlockEntity> animator = AzAnimatorAccessor.getOrNull(blockEntity);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }
}

