/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.cache.texture.GeoAbstractTexture;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.resource.GeoGlowingTextureMeta;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4573;
import net.minecraft.class_4668;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final class_4668.class_5942 SHADER_STATE = new class_4668.class_5942(class_757::method_34515);
    private static final class_4668.class_4685 TRANSPARENCY_STATE = new class_4668.class_4685("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final class_4668.class_4686 WRITE_MASK = new class_4668.class_4686(true, true);
    protected static final BiFunction<class_2960, Boolean, class_1921> GLOWING_RENDER_TYPE = class_156.method_34865((texture, isGlowing) -> {
        class_4668.class_4683 textureState = new class_4668.class_4683(texture, false, false);
        return class_1921.method_24049((String)"az_glowing_layer", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(SHADER_STATE).method_34577((class_4668.class_5939)textureState).method_23615(TRANSPARENCY_STATE).method_23616(WRITE_MASK).method_23617(isGlowing.booleanValue()));
    });
    private static final String APPENDIX = "_glowmask";
    protected final class_2960 textureBase;
    protected final class_2960 glowLayer;

    public AutoGlowingTexture(class_2960 originalLocation, class_2960 location) {
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    protected static class_2960 getEmissiveResource(class_2960 baseResource) {
        class_2960 path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.method_4616(path, (class_1044)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    @Nullable
    protected class_4573 loadTexture(class_3300 resourceManager, class_310 mc) throws IOException {
        AnimatableTexture animatableTexture;
        boolean animated;
        class_1011 class_10112;
        class_1044 originalTexture;
        try {
            originalTexture = (class_1044)mc.method_5385(() -> mc.method_1531().method_4619(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + this.textureBase, e);
        }
        class_3298 textureBaseResource = resourceManager.method_14486(this.textureBase);
        if (originalTexture instanceof class_1043) {
            class_1043 dynamicTexture = (class_1043)originalTexture;
            class_10112 = dynamicTexture.method_4525();
        } else {
            class_10112 = class_1011.method_4309((InputStream)textureBaseResource.method_14482());
        }
        class_1011 baseImage = class_10112;
        class_1011 glowImage = null;
        class_1084 textureBaseMeta = (class_1084)textureBaseResource.method_14481((class_3270)class_1084.field_5344);
        boolean blur = textureBaseMeta != null && textureBaseMeta.method_4696();
        boolean clamp = textureBaseMeta != null && textureBaseMeta.method_4697();
        try {
            class_3298 glowLayerResource = resourceManager.method_14486(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource != null) {
                glowImage = class_1011.method_4309((InputStream)glowLayerResource.method_14482());
                if (baseImage.method_4307() != glowImage.method_4307() || baseImage.method_4323() != glowImage.method_4323()) {
                    AzureLib.LOGGER.error("Glowmask size mismatch with base texture. Base size: {}x{}, Glowmask size: {}x{}, Location: {}", (Object)baseImage.method_4307(), (Object)baseImage.method_4323(), (Object)glowImage.method_4307(), (Object)glowImage.method_4323(), (Object)this.glowLayer);
                    return null;
                }
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                GeoGlowingTextureMeta meta = (GeoGlowingTextureMeta)textureBaseResource.method_14481(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta != null) {
                    glowLayerMeta = meta;
                    glowImage = new class_1011(baseImage.method_4307(), baseImage.method_4323(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (Services.PLATFORM.isDevelopmentEnvironment()) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            AzureLib.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        class_1011 mask = glowImage;
        if (mask == null) {
            String expectedGlowmask = this.textureBase.toString().replace(".png", "_glowmask.png");
            AzureLib.LOGGER.warn("Missing glowmask texture. Base texture: {}, Expected glowmask: {}", (Object)this.textureBase, (Object)expectedGlowmask);
            return null;
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && (animatableTexture = (AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.method_4624(), mask, blur, clamp);
            }
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                dynamicTexture.method_4524();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.method_4624(), baseImage, blur, clamp);
            }
        };
    }

    public static class_1921 getRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), false);
    }

    public static class_1921 getOutlineRenderType(class_2960 texture) {
        return GLOWING_RENDER_TYPE.apply(AutoGlowingTexture.getEmissiveResource(texture), true);
    }
}

