/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.platform.services.AzureLibNetwork;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class AzEntityDispatchCommandPacket
extends AbstractPacket {
    private final int entityId;
    private final AzCommand dispatchCommand;

    public AzEntityDispatchCommandPacket(int entityId, AzCommand dispatchCommand) {
        this.entityId = entityId;
        this.dispatchCommand = dispatchCommand;
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.entityId);
        AzCommand.ENCODER.accept(buf, this.dispatchCommand);
    }

    @Override
    public class_2960 getPacketID() {
        return AzureLibNetwork.AZ_ENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID;
    }

    public static AzEntityDispatchCommandPacket receive(class_2540 buf) {
        int entityId = buf.readInt();
        AzCommand dispatchCommand = AzCommand.DECODER.apply(buf);
        return new AzEntityDispatchCommandPacket(entityId, dispatchCommand);
    }

    @Override
    public void handle() {
        class_1297 entity = ClientUtils.getLevel().method_8469(this.entityId);
        if (entity == null) {
            return;
        }
        AzAnimator<class_1297> animator = AzAnimatorAccessor.getOrNull(entity);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }
}

