/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.typeadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.EasingType;
import mod.azure.azurelib.core.keyframe.BoneAnimation;
import mod.azure.azurelib.core.keyframe.Keyframe;
import mod.azure.azurelib.core.keyframe.KeyframeStack;
import mod.azure.azurelib.core.math.Constant;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.molang.MolangException;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.expressions.MolangValue;
import mod.azure.azurelib.loading.object.BakedAnimations;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class BakedAnimationsAdapter
implements JsonDeserializer<BakedAnimations> {
    public BakedAnimations deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        JsonObject animationJsonList = jsonObj.getAsJsonObject("animations");
        JsonArray includeListJSONObj = jsonObj.getAsJsonArray("includes");
        Object2ObjectOpenHashMap includes = null;
        if (includeListJSONObj != null) {
            includes = new Object2ObjectOpenHashMap(includeListJSONObj.size());
            for (JsonElement entry : includeListJSONObj.asList()) {
                JsonObject obj = entry.getAsJsonObject();
                ResourceLocation fileId = new ResourceLocation(obj.get("file_id").getAsString());
                for (JsonElement animName : obj.getAsJsonArray("animations")) {
                    String ani = animName.getAsString();
                    if (includes.containsKey(ani)) {
                        AzureLib.LOGGER.warn("Animation {} is already included! File already including: {}  File trying to include from again: {}", (Object)ani, (Object)((ResourceLocation)includes.get(ani)).toString(), (Object)fileId.toString());
                        continue;
                    }
                    includes.put(ani, fileId);
                }
            }
        }
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap(animationJsonList.size());
        for (Map.Entry entry : animationJsonList.entrySet()) {
            try {
                animations.put((String)entry.getKey(), this.bakeAnimation((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), context));
            }
            catch (MolangException ex) {
                AzureLib.LOGGER.error("Unable to parse animation: " + (String)entry.getKey());
                ex.printStackTrace();
            }
        }
        return new BakedAnimations((Map<String, Animation>)animations, (Map<String, ResourceLocation>)includes);
    }

    private Animation bakeAnimation(String name, JsonObject animationObj, JsonDeserializationContext context) throws MolangException {
        double length = animationObj.has("animation_length") ? GsonHelper.m_144784_((JsonObject)animationObj, (String)"animation_length") * 20.0 : -1.0;
        Animation.LoopType loopType = Animation.LoopType.fromJson(animationObj.get("loop"));
        BoneAnimation[] boneAnimations = this.bakeBoneAnimations(GsonHelper.m_13841_((JsonObject)animationObj, (String)"bones", (JsonObject)new JsonObject()));
        Animation.Keyframes keyframes = (Animation.Keyframes)context.deserialize((JsonElement)animationObj, Animation.Keyframes.class);
        if (length == -1.0) {
            length = BakedAnimationsAdapter.calculateAnimationLength(boneAnimations);
        }
        return new Animation(name, length, loopType, boneAnimations, keyframes);
    }

    private BoneAnimation[] bakeBoneAnimations(JsonObject bonesObj) throws MolangException {
        BoneAnimation[] animations = new BoneAnimation[bonesObj.size()];
        int index = 0;
        for (Map.Entry entry : bonesObj.entrySet()) {
            JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            KeyframeStack<Keyframe<IValue>> scaleFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getTripletObj(entryObj.get("scale")), false);
            KeyframeStack<Keyframe<IValue>> positionFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getTripletObj(entryObj.get("position")), false);
            KeyframeStack<Keyframe<IValue>> rotationFrames = this.buildKeyframeStack(BakedAnimationsAdapter.getTripletObj(entryObj.get("rotation")), true);
            animations[index] = new BoneAnimation((String)entry.getKey(), rotationFrames, positionFrames, scaleFrames);
            ++index;
        }
        return animations;
    }

    private static List<Pair<String, JsonElement>> getTripletObj(JsonElement element) {
        if (element == null) {
            return List.of();
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonArray array = new JsonArray(3);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            element = array;
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)"0", (Object)array)});
        }
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            ObjectArrayList list = new ObjectArrayList();
            for (Map.Entry entry : obj.entrySet()) {
                JsonObject entryObj;
                Object v = entry.getValue();
                if (v instanceof JsonObject && !(entryObj = (JsonObject)v).has("vector")) {
                    list.add(BakedAnimationsAdapter.getTripletObjBedrock((String)entry.getKey(), entryObj));
                    continue;
                }
                list.add(Pair.of((Object)((String)entry.getKey()), (Object)((JsonElement)entry.getValue())));
            }
            return list;
        }
        throw new JsonParseException("Invalid object type provided to getTripletObj, got: " + element);
    }

    private static Pair<String, JsonElement> getTripletObjBedrock(String timestamp, JsonObject keyframe) {
        JsonArray keyframeValues = null;
        if (keyframe.has("pre")) {
            JsonElement pre = keyframe.get("pre");
            keyframeValues = pre.isJsonArray() ? pre.getAsJsonArray() : GsonHelper.m_13933_((JsonObject)pre.getAsJsonObject(), (String)"vector");
        } else if (keyframe.has("post")) {
            JsonElement post = keyframe.get("post");
            JsonArray jsonArray = keyframeValues = post.isJsonArray() ? post.getAsJsonArray() : GsonHelper.m_13933_((JsonObject)post.getAsJsonObject(), (String)"vector");
        }
        if (keyframeValues != null) {
            return Pair.of((Object)(NumberUtils.isCreatable((String)timestamp) ? timestamp : "0"), (Object)keyframeValues);
        }
        throw new JsonParseException("Invalid keyframe data - expected array, found " + keyframe);
    }

    private KeyframeStack<Keyframe<IValue>> buildKeyframeStack(List<Pair<String, JsonElement>> entries, boolean isForRotation) throws MolangException {
        if (entries.isEmpty()) {
            return new KeyframeStack<Keyframe<IValue>>();
        }
        ObjectArrayList xFrames = new ObjectArrayList();
        ObjectArrayList yFrames = new ObjectArrayList();
        ObjectArrayList zFrames = new ObjectArrayList();
        MolangValue xPrev = null;
        MolangValue yPrev = null;
        MolangValue zPrev = null;
        Pair<String, JsonElement> prevEntry = null;
        for (Pair<String, JsonElement> entry : entries) {
            JsonObject obj;
            JsonArray array;
            String key = (String)entry.getFirst();
            JsonElement element = (JsonElement)entry.getSecond();
            if (key.equals("easing") || key.equals("easingArgs") || key.equals("lerp_mode")) continue;
            double prevTime = prevEntry != null ? Double.parseDouble((String)prevEntry.getFirst()) : 0.0;
            double curTime = NumberUtils.isCreatable((String)key) ? Double.parseDouble((String)entry.getFirst()) : 0.0;
            double timeDelta = curTime - prevTime;
            JsonArray keyFrameVector = element instanceof JsonArray ? (array = (JsonArray)element) : GsonHelper.m_13933_((JsonObject)element.getAsJsonObject(), (String)"vector");
            MolangValue rawXValue = MolangParser.parseJson(keyFrameVector.get(0));
            MolangValue rawYValue = MolangParser.parseJson(keyFrameVector.get(1));
            MolangValue rawZValue = MolangParser.parseJson(keyFrameVector.get(2));
            MolangValue xValue = isForRotation && rawXValue.isConstant() ? new Constant(Math.toRadians(-rawXValue.get())) : rawXValue;
            MolangValue yValue = isForRotation && rawYValue.isConstant() ? new Constant(Math.toRadians(-rawYValue.get())) : rawYValue;
            MolangValue zValue = isForRotation && rawZValue.isConstant() ? new Constant(Math.toRadians(rawZValue.get())) : rawZValue;
            JsonObject entryObj = element instanceof JsonObject ? (obj = (JsonObject)element) : null;
            EasingType easingType = entryObj != null && entryObj.has("easing") ? EasingType.fromJson(entryObj.get("easing")) : EasingType.LINEAR;
            ObjectArrayList easingArgs = entryObj != null && entryObj.has("easingArgs") ? JsonUtil.jsonArrayToList(GsonHelper.m_13933_((JsonObject)entryObj, (String)"easingArgs"), ele -> new Constant(ele.getAsDouble())) : new ObjectArrayList();
            xFrames.add(new Keyframe<MolangValue>(timeDelta * 20.0, prevEntry == null ? xValue : xPrev, xValue, easingType, (List<MolangValue>)easingArgs));
            yFrames.add(new Keyframe<MolangValue>(timeDelta * 20.0, prevEntry == null ? yValue : yPrev, yValue, easingType, (List<MolangValue>)easingArgs));
            zFrames.add(new Keyframe<MolangValue>(timeDelta * 20.0, prevEntry == null ? zValue : zPrev, zValue, easingType, (List<MolangValue>)easingArgs));
            xPrev = xValue;
            yPrev = yValue;
            zPrev = zValue;
            prevEntry = entry;
        }
        return new KeyframeStack<Keyframe<IValue>>((List<Keyframe<IValue>>)xFrames, (List<Keyframe<IValue>>)yFrames, (List<Keyframe<IValue>>)zFrames);
    }

    private static double calculateAnimationLength(BoneAnimation[] boneAnimations) {
        double length = 0.0;
        for (BoneAnimation animation : boneAnimations) {
            length = Math.max(length, animation.rotationKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.positionKeyFrames().getLastKeyframeTime());
            length = Math.max(length, animation.scaleKeyFrames().getLastKeyframeTime());
        }
        return length == 0.0 ? Double.MAX_VALUE : length;
    }
}

