/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModelRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class AzDynamicArmorModelRenderer
extends AzArmorModelRenderer {
    public AzDynamicArmorModelRenderer(AzArmorRendererPipeline armorRendererPipeline, AzLayerRenderer<ItemStack> layerRenderer) {
        super(armorRendererPipeline, layerRenderer);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<ItemStack> context, AzBone bone, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        AzArmorRendererPipelineContext ctx = this.armorRendererPipeline.context();
        RenderType renderType = context.renderType();
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.armorRendererPipeline.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.armorRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, new Vector3f()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), ctx.currentEntity().m_20182_().m_252839_()));
        }
        AzArmorRendererConfig config = this.armorRendererPipeline.config();
        context.setTextureOverride(this.getTextureOverrideForBone(bone, context.animatable(), context.partialTick()));
        ResourceLocation texture = context.getTextureOverride() == null ? config.textureLocation(context.animatable()) : context.getTextureOverride();
        RenderType renderTypeOverride = this.getRenderTypeOverrideForBone(bone, context.animatable(), texture, bufferSource, context.partialTick());
        if (texture != null && renderTypeOverride == null) {
            renderType = renderTypeOverride = context.getDefaultRenderType(context.animatable(), texture, context.multiBufferSource(), context.partialTick());
        }
        if (renderTypeOverride != null) {
            context.setVertexConsumer(bufferSource.m_6299_(renderTypeOverride));
            renderType = renderTypeOverride;
        }
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha())) {
            super.renderCubesOfBone(context, bone);
        }
        if (!isReRender && buffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)buffer;
            if (!builder.f_85661_) {
                context.setVertexConsumer(bufferSource.m_6299_(renderType));
            }
        }
        super.renderRecursively(context, bone, isReRender);
    }

    @Override
    protected void createVerticesOfQuad(AzRendererPipelineContext<ItemStack> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        if (context.getTextureOverride() == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        AzArmorRendererConfig config = this.armorRendererPipeline.config();
        IntIntPair boneTextureSize = context.computeTextureSize(context.getTextureOverride());
        IntIntPair entityTextureSize = context.computeTextureSize(config.textureLocation(context.animatable()));
        if (boneTextureSize == null || entityTextureSize == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        for (GeoVertex vertex : quad.vertices()) {
            Vector4f vector4f = poseState.transform(new Vector4f(vertex.position().x(), vertex.position().y(), vertex.position().z(), 1.0f));
            float texU = vertex.texU() * (float)entityTextureSize.firstInt() / (float)boneTextureSize.firstInt();
            float texV = vertex.texV() * (float)entityTextureSize.secondInt() / (float)boneTextureSize.secondInt();
            context.vertexConsumer().m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), context.red(), context.green(), context.blue(), context.alpha(), texU, texV, context.packedOverlay(), context.packedLight(), normal.x(), normal.y(), normal.z());
        }
    }
}

