/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.controller.state.impl;

import mod.azure.azurelib.animation.AzAnimationContext;
import mod.azure.azurelib.animation.controller.AzAnimationController;
import mod.azure.azurelib.animation.controller.AzAnimationControllerTimer;
import mod.azure.azurelib.animation.controller.AzAnimationQueue;
import mod.azure.azurelib.animation.controller.keyframe.AzKeyframeCallbackHandler;
import mod.azure.azurelib.animation.controller.keyframe.AzKeyframeExecutor;
import mod.azure.azurelib.animation.controller.keyframe.AzKeyframeManager;
import mod.azure.azurelib.animation.controller.state.AzAnimationState;
import mod.azure.azurelib.animation.controller.state.machine.AzAnimationControllerStateMachine;
import mod.azure.azurelib.animation.primitive.AzQueuedAnimation;

public class AzAnimationPlayState<T>
extends AzAnimationState<T> {
    @Override
    public void onEnter(AzAnimationControllerStateMachine.Context<T> context) {
        super.onEnter(context);
        AzAnimationController<T> controller = context.animationController();
        AzAnimationControllerTimer<T> controllerTimer = controller.controllerTimer();
        controllerTimer.reset();
    }

    @Override
    public void onUpdate(AzAnimationControllerStateMachine.Context<T> context) {
        boolean hasAnimationFinished;
        AzAnimationController<T> controller = context.animationController();
        AzAnimationControllerTimer<T> controllerTimer = controller.controllerTimer();
        AzQueuedAnimation currentAnimation = controller.currentAnimation();
        if (currentAnimation == null) {
            this.tryPlayNextOrStop(context);
            return;
        }
        currentAnimation.playBehavior().onUpdate(context);
        AzAnimationContext<T> animContext = context.animationContext();
        T animatable = animContext.animatable();
        boolean bl = hasAnimationFinished = controllerTimer.getAdjustedTick() >= currentAnimation.animation().length();
        if (hasAnimationFinished) {
            currentAnimation.playBehavior().onFinish(context);
        }
        if (context.stateMachine().isStopped()) {
            return;
        }
        AzKeyframeManager<T> keyframeManager = controller.keyframeManager();
        AzKeyframeExecutor<T> keyframeExecutor = keyframeManager.keyframeExecutor();
        boolean crashWhenCantFindBone = animContext.config().crashIfBoneMissing();
        keyframeExecutor.execute(currentAnimation, animatable, crashWhenCantFindBone);
    }

    private void tryPlayNextOrStop(AzAnimationControllerStateMachine.Context<T> context) {
        AzAnimationController<T> controller = context.animationController();
        AzAnimationControllerStateMachine<T> stateMachine = context.stateMachine();
        AzKeyframeManager<T> keyframeManager = controller.keyframeManager();
        AzKeyframeCallbackHandler<T> keyframeCallbackHandler = keyframeManager.keyframeCallbackHandler();
        keyframeCallbackHandler.reset();
        AzAnimationQueue animationQueue = controller.animationQueue();
        AzQueuedAnimation nextAnimation = animationQueue.peek();
        if (nextAnimation == null) {
            stateMachine.stop();
            return;
        }
        stateMachine.transition();
        controller.setCurrentAnimation(nextAnimation);
    }
}

