/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.client.screen;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.client.DisplayAdapter;
import mod.azure.azurelib.client.DisplayAdapterManager;
import mod.azure.azurelib.client.screen.AbstractConfigScreen;
import mod.azure.azurelib.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.validate.NotificationSeverity;
import mod.azure.azurelib.config.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> valueMap;

    public ConfigScreen(String ownerIdentifier, String configId, Map<String, ConfigValue<?>> valueMap, class_437 previous) {
        this((class_2561)new class_2588("config.screen." + ownerIdentifier), configId, valueMap, previous);
    }

    public ConfigScreen(class_2561 screenTitle, String configId, Map<String, ConfigValue<?>> valueMap, class_437 previous) {
        super(screenTitle, previous, configId);
        this.valueMap = valueMap;
    }

    protected void method_25426() {
        int viewportMin = 35;
        int viewportHeight = this.field_22790 - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.method_37063((class_364)new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.field_22789 - 60, 20, value, this.configId));
            widget.setDescriptionRenderer(this::renderEntryDescription);
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = DisplayAdapterManager.forType(field.getType());
            if (adapter == null) {
                AzureLib.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(value, field, widget);
                this.initializeGuiValue(value, widget);
                continue;
            }
            catch (ClassCastException e) {
                AzureLib.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)field.getType().getSimpleName(), (Object)e);
            }
        }
        this.addFooter();
    }

    private void renderEntryDescription(class_4587 stack, class_339 widget, NotificationSeverity severity, List<class_5481> text) {
        int x = widget.field_22760 + 5;
        int y = widget.field_22761 + widget.method_25364() + 10;
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, stack, text, x, y);
        } else {
            this.renderNotification(NotificationSeverity.INFO, stack, text, x, y);
        }
    }

    public void method_25394(@NotNull class_4587 stack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(stack);
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        float f = (float)(this.field_22789 - titleWidth) / 2.0f;
        Objects.requireNonNull(this.field_22793);
        this.field_22793.method_30883(stack, this.field_22785, f, (float)(35 - 9) / 2.0f, 0xFFFFFF);
        ConfigScreen.method_25294((class_4587)stack, (int)0, (int)35, (int)this.field_22789, (int)(this.field_22790 - 30), (int)-1728053248);
        ConfigScreen.renderScrollbar(stack, this.field_22789 - 5, 35, 5, this.field_22790 - 30 - 35, this.index, this.valueMap.size(), this.pageSize);
        super.method_25394(stack, mouseX, mouseY, partialTicks);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return false;
    }
}

