/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util.client;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.model.AzBone;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public final class RenderUtils {
    private static final class_1158 QX = new class_1158(0.0f, 0.0f, 0.0f, 1.0f);
    private static final class_1158 QY = new class_1158(0.0f, 0.0f, 0.0f, 1.0f);
    private static final class_1158 QZ = new class_1158(0.0f, 0.0f, 0.0f, 1.0f);

    public static void translateMatrixToBone(class_4587 poseStack, AzBone bone) {
        poseStack.method_22904((double)(-bone.getPosX() / 16.0f), (double)(bone.getPosY() / 16.0f), (double)(bone.getPosZ() / 16.0f));
    }

    public static void rotateMatrixAroundBone(class_4587 poseStack, AzBone bone) {
        float rz = bone.getRotZ();
        float ry = bone.getRotY();
        float rx = bone.getRotX();
        if (rz != 0.0f) {
            RenderUtils.setQuatFromRotZ(QZ, rz);
            poseStack.method_22907(QZ);
        }
        if (ry != 0.0f) {
            RenderUtils.setQuatFromRotY(QY, ry);
            poseStack.method_22907(QY);
        }
        if (rx != 0.0f) {
            RenderUtils.setQuatFromRotX(QX, rx);
            poseStack.method_22907(QX);
        }
    }

    public static void rotateMatrixAroundCube(class_4587 poseStack, GeoCube cube) {
        class_243 rotation = cube.rotation();
        if (rotation.method_10215() != 0.0) {
            RenderUtils.setQuatFromRotZ(QZ, (float)rotation.method_10215());
            poseStack.method_22907(QZ);
        }
        if (rotation.method_10214() != 0.0) {
            RenderUtils.setQuatFromRotY(QY, (float)rotation.method_10214());
            poseStack.method_22907(QY);
        }
        if (rotation.method_10216() != 0.0) {
            RenderUtils.setQuatFromRotX(QX, (float)rotation.method_10216());
            poseStack.method_22907(QX);
        }
    }

    public static void scaleMatrixForBone(class_4587 poseStack, AzBone bone) {
        poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(pivot.method_10216() / 16.0, pivot.method_10214() / 16.0, pivot.method_10215() / 16.0);
    }

    public static void translateToPivotPoint(class_4587 poseStack, AzBone bone) {
        poseStack.method_22904((double)(bone.getPivotX() / 16.0f), (double)(bone.getPivotY() / 16.0f), (double)(bone.getPivotZ() / 16.0f));
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(-pivot.method_10216() / 16.0, -pivot.method_10214() / 16.0, -pivot.method_10215() / 16.0);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, AzBone bone) {
        poseStack.method_22904((double)(-bone.getPivotX() / 16.0f), (double)(-bone.getPivotY() / 16.0f), (double)(-bone.getPivotZ() / 16.0f));
    }

    public static void translateAndRotateMatrixForBone(class_4587 poseStack, AzBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(class_4587 poseStack, AzBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static class_1159 invertAndMultiplyMatrices(class_1159 baseMatrix, class_1159 inputMatrix) {
        inputMatrix = new class_1159(inputMatrix);
        inputMatrix.method_22870();
        inputMatrix.method_22672(baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907(class_1160.field_20705.method_23214(class_3532.method_16439((float)partialTick, (float)animatable.field_5982, (float)animatable.method_36454()) - 90.0f));
        poseStack.method_22907(class_1160.field_20707.method_23214(class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455())));
    }

    private static void setQuatFromRotX(class_1158 q, float angleRad) {
        float h = angleRad * 0.5f;
        float s = class_3532.method_15374((float)h);
        float c = class_3532.method_15362((float)h);
        q.method_23758(s, 0.0f, 0.0f, c);
    }

    private static void setQuatFromRotY(class_1158 q, float angleRad) {
        float h = angleRad * 0.5f;
        float s = class_3532.method_15374((float)h);
        float c = class_3532.method_15362((float)h);
        q.method_23758(0.0f, s, 0.0f, c);
    }

    private static void setQuatFromRotZ(class_1158 q, float angleRad) {
        float h = angleRad * 0.5f;
        float s = class_3532.method_15374((float)h);
        float c = class_3532.method_15362((float)h);
        q.method_23758(0.0f, 0.0f, s, c);
    }

    @Nullable
    public static IntIntPair getTextureDimensions(class_2960 texture) {
        if (texture == null) {
            return null;
        }
        class_1044 originalTexture = null;
        class_310 mc = class_310.method_1551();
        try {
            originalTexture = (class_1044)mc.method_5385(() -> mc.method_1531().method_4619(texture)).get();
        }
        catch (Exception e) {
            AzureLib.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        class_1011 image = null;
        try {
            class_1011 class_10112;
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                class_10112 = dynamicTexture.method_4525();
            } else {
                class_10112 = class_1011.method_4309((InputStream)mc.method_1478().method_14486(texture).method_14482());
            }
            image = class_10112;
        }
        catch (Exception e) {
            AzureLib.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.method_4307(), (int)image.method_4323());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return class_3673.method_15974() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static class_243 arrayToVec(double[] array) {
        return new class_243(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(class_630 from, AzBone to) {
        to.updateRotation(-from.field_3654, -from.field_3675, from.field_3674);
    }

    public static void fixInvertedFlatCube(GeoCube cube, class_1160 normal) {
        if (normal.method_4943() < 0.0f && (cube.size().method_10214() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.method_23849(-1.0f, 1.0f, 1.0f);
        }
        if (normal.method_4945() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.method_23849(1.0f, -1.0f, 1.0f);
        }
        if (normal.method_4947() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10214() == 0.0)) {
            normal.method_23849(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> 90.0f;
            case class_2350.field_11043 -> 270.0f;
            case class_2350.field_11034 -> 180.0f;
            default -> 0.0f;
        };
    }

    private RenderUtils() {
        throw new UnsupportedOperationException();
    }
}

