/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command.action.registry;

import it.unimi.dsi.fastutil.objects.Object2ShortArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerCancelAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerPlayAnimationSequenceAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerSetAnimationSpeedAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerSetEasingTypeAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerSetFreezeTickAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerSetRepeatTimesAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerSetReverseAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerSetStartTickOffsetAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.controller.AzControllerSetTransitionSpeedAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root.AzRootCancelAllAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root.AzRootPlayAnimationSequenceAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root.AzRootSetAnimationSpeedAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root.AzRootSetEasingTypeAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root.AzRootSetStartTickOffsetAction;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.impl.root.AzRootSetTransitionSpeedAction;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class AzActionRegistry {
    private static final Map<class_2960, Short> RESOURCE_LOCATION_TO_ID = new Object2ShortArrayMap();
    private static final Map<Short, Function<class_2540, AzAction>> DECODERS_BY_ID = new HashMap<Short, Function<class_2540, AzAction>>();
    private static final Map<Short, BiConsumer<class_2540, AzAction>> ENCODERS_BY_ID = new HashMap<Short, BiConsumer<class_2540, AzAction>>();
    private static short NEXT_FREE_ID = 0;

    @Nullable
    public static Function<class_2540, ? extends AzAction> getDecoderOrNull(class_2960 resourceLocation) {
        Short id = RESOURCE_LOCATION_TO_ID.get(resourceLocation);
        return DECODERS_BY_ID.get(id);
    }

    @Nullable
    public static Function<class_2540, AzAction> getDecoderOrNull(short id) {
        return DECODERS_BY_ID.get(id);
    }

    @Nullable
    public static BiConsumer<class_2540, AzAction> getEncoderOrNull(class_2960 resourceLocation) {
        Short id = RESOURCE_LOCATION_TO_ID.get(resourceLocation);
        return ENCODERS_BY_ID.get(id);
    }

    @Nullable
    public static BiConsumer<class_2540, AzAction> getEncoderOrNull(short id) {
        return ENCODERS_BY_ID.get(id);
    }

    @Nullable
    public static Short getIdOrNull(class_2960 resourceLocation) {
        return RESOURCE_LOCATION_TO_ID.get(resourceLocation);
    }

    private static <A extends AzAction> void register(class_2960 resourceLocation, Function<class_2540, A> decoder, BiConsumer<class_2540, A> encoder) {
        Short id = RESOURCE_LOCATION_TO_ID.computeIfAbsent(resourceLocation, $ -> {
            short s = NEXT_FREE_ID;
            NEXT_FREE_ID = (short)(s + 1);
            return s;
        });
        DECODERS_BY_ID.put(id, decoder);
        ENCODERS_BY_ID.put(id, encoder);
    }

    static {
        AzActionRegistry.register(AzRootCancelAllAction.RESOURCE_LOCATION, AzRootCancelAllAction::decode, AzRootCancelAllAction::encode);
        AzActionRegistry.register(AzRootPlayAnimationSequenceAction.RESOURCE_LOCATION, AzRootPlayAnimationSequenceAction::decode, AzRootPlayAnimationSequenceAction::encode);
        AzActionRegistry.register(AzRootSetAnimationSpeedAction.RESOURCE_LOCATION, AzRootSetAnimationSpeedAction::decode, AzRootSetAnimationSpeedAction::encode);
        AzActionRegistry.register(AzRootSetEasingTypeAction.RESOURCE_LOCATION, AzRootSetEasingTypeAction::decode, AzRootSetEasingTypeAction::encode);
        AzActionRegistry.register(AzRootSetTransitionSpeedAction.RESOURCE_LOCATION, AzRootSetTransitionSpeedAction::decode, AzRootSetTransitionSpeedAction::encode);
        AzActionRegistry.register(AzRootSetStartTickOffsetAction.RESOURCE_LOCATION, AzRootSetStartTickOffsetAction::decode, AzRootSetStartTickOffsetAction::encode);
        AzActionRegistry.register(AzControllerCancelAction.RESOURCE_LOCATION, AzControllerCancelAction::decode, AzControllerCancelAction::encode);
        AzActionRegistry.register(AzControllerPlayAnimationSequenceAction.RESOURCE_LOCATION, AzControllerPlayAnimationSequenceAction::decode, AzControllerPlayAnimationSequenceAction::encode);
        AzActionRegistry.register(AzControllerSetAnimationSpeedAction.RESOURCE_LOCATION, AzControllerSetAnimationSpeedAction::decode, AzControllerSetAnimationSpeedAction::encode);
        AzActionRegistry.register(AzControllerSetEasingTypeAction.RESOURCE_LOCATION, AzControllerSetEasingTypeAction::decode, AzControllerSetEasingTypeAction::encode);
        AzActionRegistry.register(AzControllerSetTransitionSpeedAction.RESOURCE_LOCATION, AzControllerSetTransitionSpeedAction::decode, AzControllerSetTransitionSpeedAction::encode);
        AzActionRegistry.register(AzControllerSetStartTickOffsetAction.RESOURCE_LOCATION, AzControllerSetStartTickOffsetAction::decode, AzControllerSetStartTickOffsetAction::encode);
        AzActionRegistry.register(AzControllerSetFreezeTickAction.RESOURCE_LOCATION, AzControllerSetFreezeTickAction::decode, AzControllerSetFreezeTickAction::encode);
        AzActionRegistry.register(AzControllerSetRepeatTimesAction.RESOURCE_LOCATION, AzControllerSetRepeatTimesAction::decode, AzControllerSetRepeatTimesAction::encode);
        AzActionRegistry.register(AzControllerSetReverseAction.RESOURCE_LOCATION, AzControllerSetReverseAction::decode, AzControllerSetReverseAction::encode);
    }
}

