/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelib.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelib.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import net.minecraft.class_4720;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AzModelRenderer<T> {
    private final Matrix4f poseStateCache = new Matrix4f();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
        AzRendererConfig<T> config = this.rendererPipeline.config();
        config.renderEntry(context);
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        class_4588 buffer = context.vertexConsumer();
        class_4597 bufferSource = context.multiBufferSource();
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        context.setVertexConsumer(this.getOrRefreshRenderBuffer(isReRender, context, bone));
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.renderColor())) {
            this.renderCubesOfBone(context, bone);
        }
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        class_4587 poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(context, cube);
            poseStack.method_22909();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        class_4587 poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = this.poseStateCache.set((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        class_4588 buffer = context.vertexConsumer();
        int color = context.renderColor();
        AzRendererConfig<T> config = this.rendererPipeline.config();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        IntIntPair boneTextureSize = context.computeTextureSize(context.getTextureOverride());
        IntIntPair entityTextureSize = context.computeTextureSize(config.textureLocation(context.animatable()));
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            if (context.getTextureOverride() != null && boneTextureSize != null && entityTextureSize != null) {
                float texU = vertex.texU() * (float)entityTextureSize.firstInt() / (float)boneTextureSize.firstInt();
                float texV = vertex.texV() * (float)entityTextureSize.secondInt() / (float)boneTextureSize.secondInt();
                context.vertexConsumer().method_23919(vector4f.x(), vector4f.y(), vector4f.z(), -1, texU, texV, context.packedOverlay(), context.packedLight(), normal.x(), normal.y(), normal.z());
                continue;
            }
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), color, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    public boolean boneRenderOverride(class_4587 poseStack, AzBone bone, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        return false;
    }

    @Nullable
    public class_1921 getRenderTypeOverrideForBone(AzBone bone, T animatable, class_2960 texturePath, class_4597 bufferSource, float partialTick) {
        return null;
    }

    @Nullable
    public class_2960 getTextureOverrideForBone(AzBone bone, T animatable, float partialTick) {
        return null;
    }

    public void handleAnimation(AzAnimator<T> animator, T animatable, float partialTick) {
        animator.animate(animatable, partialTick);
    }

    public class_4588 getOrRefreshRenderBuffer(boolean isReRender, AzRendererPipelineContext<T> context, AzBone bone) {
        class_4588 class_45882;
        AzRendererConfig<T> config = this.rendererPipeline.config();
        class_4588 currentBuffer = context.vertexConsumer();
        class_4597 bufferSource = context.multiBufferSource();
        class_1921 renderType = context.renderType();
        if (config.boneTextureOverrideProvider(bone) != null) {
            context.setTextureOverride(config.boneTextureOverrideProvider(bone));
        }
        class_2960 texture = config.boneTextureOverrideProvider(bone);
        class_1921 renderTypeOverride = config.boneRenderTypeOverrideProvider(bone);
        if (texture != null && renderTypeOverride == null) {
            renderTypeOverride = context.getDefaultRenderType(context.animatable(), texture, bufferSource, context.partialTick());
        }
        if (renderTypeOverride != null) {
            currentBuffer = context.multiBufferSource().getBuffer(renderTypeOverride);
        }
        if (isReRender) {
            return currentBuffer;
        }
        class_4588 class_45883 = currentBuffer;
        Objects.requireNonNull(class_45883);
        class_4588 class_45884 = class_45883;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_287.class, class_4618.class_4586.class, class_4720.class_4589.class}, (Object)class_45884, n)) {
                case 0: {
                    class_287 builder = (class_287)class_45884;
                    if (!this.isBufferInactive(builder)) {
                        n = 1;
                        continue block5;
                    }
                    class_45882 = bufferSource.getBuffer(renderType);
                    break block5;
                }
                case 1: {
                    class_4618.class_4586 outline = (class_4618.class_4586)class_45884;
                    if (!this.needsBufferRefresh(outline.comp_2851())) {
                        n = 2;
                        continue block5;
                    }
                    class_45882 = new class_4618.class_4586(bufferSource.getBuffer(renderType), outline.comp_2852());
                    break block5;
                }
                case 2: {
                    class_4720.class_4589 pair = (class_4720.class_4589)class_45884;
                    if (!this.needsBufferRefresh(pair.field_21685) && !this.needsBufferRefresh(pair.field_21686)) {
                        n = 3;
                        continue block5;
                    }
                    class_45882 = new class_4720.class_4589(this.needsBufferRefresh(pair.field_21685) ? bufferSource.getBuffer(renderType) : pair.field_21685, this.needsBufferRefresh(pair.field_21686) ? bufferSource.getBuffer(renderType) : pair.field_21686);
                    break block5;
                }
                default: {
                    class_45882 = currentBuffer;
                    break block5;
                }
            }
            break;
        }
        return class_45882;
    }

    private boolean needsBufferRefresh(class_4588 buffer) {
        class_4588 class_45882 = buffer;
        Objects.requireNonNull(class_45882);
        class_4588 class_45883 = class_45882;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_287.class, class_4618.class_4586.class, class_4720.class_4589.class}, (Object)class_45883, n)) {
            case 0 -> {
                class_287 builder = (class_287)class_45883;
                yield this.isBufferInactive(builder);
            }
            case 1 -> {
                class_4618.class_4586 outline = (class_4618.class_4586)class_45883;
                yield this.needsBufferRefresh(outline.comp_2851());
            }
            case 2 -> {
                class_4720.class_4589 pair = (class_4720.class_4589)class_45883;
                if (this.needsBufferRefresh(pair.field_21685) || this.needsBufferRefresh(pair.field_21686)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isBufferInactive(class_287 builder) {
        return !builder.field_1556;
    }
}

