/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelib.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelib.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class AzModelRenderer<T> {
    private final Matrix4f poseStateCache = new Matrix4f();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;
    private final Vector4f poseStateTransformCache = new Vector4f();

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
        AzRendererConfig<T> config = this.rendererPipeline.config();
        config.renderEntry(context);
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.popPose();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        PoseStack poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.pushPose();
            this.renderCube(context, cube);
            poseStack.popPose();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        PoseStack poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.last().normal();
        Matrix4f poseState = this.poseStateCache.set((Matrix4fc)poseStack.last().pose());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        VertexConsumer buffer = context.vertexConsumer();
        int color = context.renderColor();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            this.poseStateTransformCache.set(position.x(), position.y(), position.z(), 1.0f);
            Vector4f vector4f = poseState.transform(this.poseStateTransformCache);
            buffer.addVertex(vector4f.x(), vector4f.y(), vector4f.z(), color, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    public boolean boneRenderOverride(PoseStack poseStack, AzBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        return false;
    }

    @Nullable
    public RenderType getRenderTypeOverrideForBone(AzBone bone, T animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        return null;
    }

    @Nullable
    public ResourceLocation getTextureOverrideForBone(AzBone bone, T animatable, float partialTick) {
        return null;
    }

    public void handleAnimation(AzAnimator<T> animator, T animatable, float partialTick) {
        animator.animate(animatable, partialTick);
    }

    public VertexConsumer getOrRefreshRenderBuffer(boolean isReRender, AzRendererPipelineContext<T> context) {
        VertexConsumer vertexConsumer;
        VertexConsumer currentBuffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        RenderType renderType = context.renderType();
        if (isReRender) {
            return currentBuffer;
        }
        VertexConsumer vertexConsumer2 = currentBuffer;
        Objects.requireNonNull(vertexConsumer2);
        VertexConsumer vertexConsumer3 = vertexConsumer2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BufferBuilder.class, OutlineBufferSource.EntityOutlineGenerator.class, VertexMultiConsumer.Double.class}, (Object)vertexConsumer3, n)) {
                case 0: {
                    BufferBuilder builder = (BufferBuilder)vertexConsumer3;
                    if (!this.isBufferInactive(builder)) {
                        n = 1;
                        continue block5;
                    }
                    vertexConsumer = bufferSource.getBuffer(renderType);
                    break block5;
                }
                case 1: {
                    OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)vertexConsumer3;
                    if (!this.needsBufferRefresh(outline.delegate())) {
                        n = 2;
                        continue block5;
                    }
                    vertexConsumer = new OutlineBufferSource.EntityOutlineGenerator(bufferSource.getBuffer(renderType), outline.color());
                    break block5;
                }
                case 2: {
                    VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)vertexConsumer3;
                    if (!this.needsBufferRefresh(pair.first) && !this.needsBufferRefresh(pair.second)) {
                        n = 3;
                        continue block5;
                    }
                    vertexConsumer = new VertexMultiConsumer.Double(this.needsBufferRefresh(pair.first) ? bufferSource.getBuffer(renderType) : pair.first, this.needsBufferRefresh(pair.second) ? bufferSource.getBuffer(renderType) : pair.second);
                    break block5;
                }
                default: {
                    vertexConsumer = currentBuffer;
                    break block5;
                }
            }
            break;
        }
        return vertexConsumer;
    }

    private boolean needsBufferRefresh(VertexConsumer buffer) {
        VertexConsumer vertexConsumer = buffer;
        Objects.requireNonNull(vertexConsumer);
        VertexConsumer vertexConsumer2 = vertexConsumer;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BufferBuilder.class, OutlineBufferSource.EntityOutlineGenerator.class, VertexMultiConsumer.Double.class}, (Object)vertexConsumer2, n)) {
            case 0 -> {
                BufferBuilder builder = (BufferBuilder)vertexConsumer2;
                yield this.isBufferInactive(builder);
            }
            case 1 -> {
                OutlineBufferSource.EntityOutlineGenerator outline = (OutlineBufferSource.EntityOutlineGenerator)vertexConsumer2;
                yield this.needsBufferRefresh(outline.delegate());
            }
            case 2 -> {
                VertexMultiConsumer.Double pair = (VertexMultiConsumer.Double)vertexConsumer2;
                if (this.needsBufferRefresh(pair.first) || this.needsBufferRefresh(pair.second)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isBufferInactive(BufferBuilder builder) {
        return !builder.building;
    }
}

