/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.easing;

import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.utils.Interpolations;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypeRegistry;
import net.minecraft.network.FriendlyByteBuf;

public interface AzEasingType {
    public static final Function<FriendlyByteBuf, AzEasingType> DECODER = buf -> Objects.requireNonNull(AzEasingTypeRegistry.getOrNull(buf.m_130277_()));
    public static final BiConsumer<FriendlyByteBuf, AzEasingType> ENCODER = (buf, val) -> buf.m_130070_(val.name());

    public String name();

    public Double2DoubleFunction buildTransformer(Double var1);

    default public double apply(AzAnimationPoint animationPoint) {
        Double easingVariable = null;
        if (animationPoint.keyframe() != null && animationPoint.keyframe().easingArgs().size() > 0) {
            easingVariable = ((IValue)animationPoint.keyframe().easingArgs().get(0)).get();
        }
        return this.apply(animationPoint, easingVariable, animationPoint.currentTick() / animationPoint.transitionLength());
    }

    default public double apply(AzAnimationPoint animationPoint, Double easingValue, double lerpValue) {
        if (animationPoint.currentTick() >= animationPoint.transitionLength()) {
            return (float)animationPoint.animationEndValue();
        }
        return Interpolations.lerp(animationPoint.animationStartValue(), animationPoint.animationEndValue(), (Double)this.buildTransformer(easingValue).apply((Object)lerpValue));
    }
}

