/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.config.value;

import java.lang.reflect.Field;
import mod.azure.azurelib.common.internal.common.config.ConfigUtils;
import mod.azure.azurelib.common.internal.common.config.adapter.TypeAdapter;
import mod.azure.azurelib.common.internal.common.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.common.internal.common.config.format.IConfigFormat;
import mod.azure.azurelib.common.internal.common.config.value.ConfigValue;
import mod.azure.azurelib.common.internal.common.config.value.DecimalValue;
import mod.azure.azurelib.common.internal.common.config.value.ValueData;
import net.minecraft.class_2540;

public class FloatValue
extends DecimalValue<Float> {
    public FloatValue(ValueData<Float> valueData) {
        super(valueData, DecimalValue.Range.unboundedFloat());
    }

    @Override
    public Float getCorrectedValue(Float in) {
        if (this.range == null) {
            return in;
        }
        if (!this.range.isWithin(in.floatValue())) {
            float corrected = this.range.clamp(in.floatValue());
            ConfigUtils.logCorrectedMessage(this.getId(), in, Float.valueOf(corrected));
            return Float.valueOf(corrected);
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeFloat(this.getId(), ((Float)this.get()).floatValue());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(Float.valueOf(format.readFloat(this.getId())));
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new FloatValue(ValueData.of(name, Float.valueOf(((Float)value).floatValue()), context, comments));
        }

        @Override
        public void encodeToBuffer(ConfigValue<?> value, class_2540 buffer) {
            buffer.method_52941(((Float)value.get()).floatValue());
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, class_2540 buffer) {
            return Float.valueOf(buffer.readFloat());
        }

        @Override
        public void setFieldValue(Field field, Object instance, Object value) throws IllegalAccessException {
            field.setFloat(instance, ((Float)value).floatValue());
        }
    }
}

