/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.controller;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import mod.azure.azurelib.rewrite.animation.AzBoneAnimationUpdateUtil;
import mod.azure.azurelib.rewrite.animation.cache.AzBoneCache;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzBoneAnimationQueue;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.model.AzBoneSnapshot;
import org.jetbrains.annotations.Nullable;

public class AzBoneAnimationQueueCache<T> {
    private final Map<String, AzBoneAnimationQueue> boneAnimationQueues = new Object2ObjectOpenHashMap();
    private final AzBoneCache boneCache;

    public AzBoneAnimationQueueCache(AzBoneCache boneCache) {
        this.boneCache = boneCache;
    }

    public void update(AzEasingType easingType) {
        Map<String, AzBoneSnapshot> boneSnapshots = this.boneCache.getBoneSnapshotsByName();
        for (AzBoneAnimationQueue boneAnimation : this.boneAnimationQueues.values()) {
            AzBone bone = boneAnimation.bone();
            AzBoneSnapshot snapshot = boneSnapshots.get(bone.getName());
            AzBoneSnapshot initialSnapshot = bone.getInitialAzSnapshot();
            AzBoneAnimationUpdateUtil.updateRotations(boneAnimation, bone, easingType, initialSnapshot, snapshot);
            AzBoneAnimationUpdateUtil.updatePositions(boneAnimation, bone, easingType, snapshot);
            AzBoneAnimationUpdateUtil.updateScale(boneAnimation, bone, easingType, snapshot);
        }
    }

    public Collection<AzBoneAnimationQueue> values() {
        return this.boneAnimationQueues.values();
    }

    @Nullable
    public AzBoneAnimationQueue getOrNull(String boneName) {
        AzBone bone = this.boneCache.getBakedModel().getBoneOrNull(boneName);
        if (bone == null) {
            return null;
        }
        return this.boneAnimationQueues.computeIfAbsent(boneName, $ -> new AzBoneAnimationQueue(bone));
    }

    public void clear() {
        this.boneAnimationQueues.clear();
    }
}

