/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelib.core.object.Color;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_2484;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_836;
import net.minecraft.class_9282;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzArmorLayer<T extends class_1309>
implements AzRenderLayer<T> {
    protected static final class_572<class_1309> INNER_ARMOR_MODEL = new class_572(class_310.method_1551().method_31974().method_32072(class_5602.field_27579));
    protected static final class_572<class_1309> OUTER_ARMOR_MODEL = new class_572(class_310.method_1551().method_31974().method_32072(class_5602.field_27580));
    @Nullable
    protected class_1799 mainHandStack;
    @Nullable
    protected class_1799 offhandStack;
    @Nullable
    protected class_1799 helmetStack;
    @Nullable
    protected class_1799 chestplateStack;
    @Nullable
    protected class_1799 leggingsStack;
    @Nullable
    protected class_1799 bootsStack;

    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
        class_1309 animatable = (class_1309)context.animatable();
        this.mainHandStack = animatable.method_6118(class_1304.field_6173);
        this.offhandStack = animatable.method_6118(class_1304.field_6171);
        this.helmetStack = animatable.method_6118(class_1304.field_6169);
        this.chestplateStack = animatable.method_6118(class_1304.field_6174);
        this.leggingsStack = animatable.method_6118(class_1304.field_6172);
        this.bootsStack = animatable.method_6118(class_1304.field_6166);
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        class_1747 blockItem;
        class_1799 armorStack = this.getArmorItemForBone(context, bone);
        if (armorStack == null) {
            return;
        }
        class_1792 class_17922 = armorStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2190) {
            class_2190 skullBlock = (class_2190)class_17922;
            this.renderSkullAsArmor(context, bone, armorStack, skullBlock);
        } else {
            this.renderArmor(context, bone, armorStack);
        }
    }

    public void renderArmor(AzRendererPipelineContext<T> context, AzBone bone, class_1799 armorStack) {
        class_1304 slot = this.getEquipmentSlotForBone(context, bone, armorStack);
        class_572<T> model = this.getModelForItem(slot);
        class_630 modelPart = this.getModelPartForBone(context, bone, model);
        AzArmorRenderer renderer = AzArmorRendererRegistry.getOrNull(armorStack);
        if (!modelPart.field_3663.isEmpty()) {
            context.poseStack().method_22903();
            context.poseStack().method_22905(-1.0f, -1.0f, 1.0f);
            if (armorStack.method_7909() instanceof class_1738) {
                this.prepModelPartForRender(context, bone, modelPart);
                if (renderer != null) {
                    this.renderAzArmorPiece(renderer, context, bone, slot, armorStack, modelPart, model);
                } else {
                    this.renderArmorPiece(context, bone, slot, armorStack, modelPart);
                }
            }
            context.poseStack().method_22909();
        }
    }

    @NotNull
    protected class_1304 getEquipmentSlotForBone(AzRendererPipelineContext<T> context, AzBone bone, class_1799 stack) {
        class_1309 animatable = (class_1309)context.animatable();
        for (class_1304 slot : class_1304.values()) {
            boolean isHumanoidArmorSlotType;
            boolean bl = isHumanoidArmorSlotType = slot.method_5925() == class_1304.class_1305.field_6178;
            if (!isHumanoidArmorSlotType || stack != animatable.method_6118(slot)) continue;
            return slot;
        }
        return class_1304.field_6174;
    }

    @NotNull
    protected class_630 getModelPartForBone(AzRendererPipelineContext<T> context, AzBone bone, class_572<?> baseModel) {
        return baseModel.field_3391;
    }

    @Nullable
    protected class_1799 getArmorItemForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        return null;
    }

    protected <I extends class_1792> void renderAzArmorPiece(AzArmorRenderer renderer, AzRendererPipelineContext<T> context, AzBone bone, class_1304 slot, class_1799 armorStack, class_630 modelPart, class_572<T> baseModel) {
        AzArmorModel armorModel = renderer.rendererPipeline().armorModel();
        AzArmorBoneContext boneContext = renderer.rendererPipeline().context().boneContext();
        int color = armorStack.method_31573(class_3489.field_48803) ? class_9282.method_57470((class_1799)armorStack, (int)-6265536) : -1;
        renderer.prepForRender((class_1297)context.animatable(), armorStack, slot, baseModel);
        boneContext.applyBoneVisibilityByPart(slot, modelPart, baseModel);
        armorModel.method_2828(context.poseStack(), null, context.packedLight(), class_4608.field_21444, color);
    }

    protected <I extends class_1792> void renderArmorPiece(AzRendererPipelineContext<T> context, AzBone bone, class_1304 slot, class_1799 armorStack, class_630 modelPart) {
        class_4588 buffer;
        int color = armorStack.method_31573(class_3489.field_48803) ? class_9282.method_57470((class_1799)armorStack, (int)-6265536) : -1;
        class_6880 material = ((class_1738)armorStack.method_7909()).method_7686();
        for (class_1741.class_9196 layer : ((class_1741)material.comp_349()).comp_2302()) {
            buffer = this.getVanillaArmorBuffer(context, armorStack, slot, bone, layer, false);
            modelPart.method_22699(context.poseStack(), buffer, context.packedLight(), context.packedOverlay(), color);
        }
        class_8053 trim = (class_8053)armorStack.method_57824(class_9334.field_49607);
        if (trim != null) {
            class_1058 sprite = class_310.method_1551().method_1554().method_24153(class_4722.field_42071).method_4608(slot == class_1304.field_6172 ? trim.method_48434(material) : trim.method_48436(material));
            buffer = sprite.method_24108(context.multiBufferSource().getBuffer(class_4722.method_48480((boolean)((class_8056)trim.method_48424().comp_349()).comp_1905())));
            modelPart.method_22698(context.poseStack(), buffer, context.packedLight(), context.packedOverlay());
        }
        if (armorStack.method_7958()) {
            modelPart.method_22699(context.poseStack(), this.getVanillaArmorBuffer(context, armorStack, slot, bone, null, true), context.packedLight(), context.packedOverlay(), Color.WHITE.argbInt());
        }
    }

    protected class_4588 getVanillaArmorBuffer(AzRendererPipelineContext<T> context, class_1799 stack, class_1304 slot, AzBone bone, @Nullable class_1741.class_9196 layer, boolean forGlint) {
        if (forGlint) {
            return context.multiBufferSource().getBuffer(class_1921.method_27949());
        }
        return context.multiBufferSource().getBuffer(class_1921.method_25448((class_2960)layer.method_56693(slot == class_1304.field_6172)));
    }

    @Nullable
    protected AzArmorRenderer getRendererForItem(class_1799 stack) {
        return AzArmorRendererRegistry.getOrNull(stack);
    }

    protected class_572<T> getModelForItem(class_1304 slot) {
        return slot == class_1304.field_6172 ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
    }

    protected void renderSkullAsArmor(AzRendererPipelineContext<T> context, AzBone bone, class_1799 stack, class_2190 skullBlock) {
        class_2484.class_2485 type = skullBlock.method_9327();
        class_5598 model = (class_5598)class_836.method_32160((class_5599)class_310.method_1551().method_31974()).get(type);
        class_1921 renderType = class_836.method_3578((class_2484.class_2485)type, (class_9296)((class_9296)stack.method_57824(class_9334.field_49617)));
        context.poseStack().method_22903();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        context.poseStack().method_22905(1.1875f, 1.1875f, 1.1875f);
        context.poseStack().method_46416(-0.5f, 0.0f, -0.5f);
        class_836.method_32161(null, (float)0.0f, (float)0.0f, (class_4587)context.poseStack(), (class_4597)context.multiBufferSource(), (int)context.packedLight(), (class_5598)model, (class_1921)renderType);
        context.poseStack().method_22909();
    }

    protected void prepModelPartForRender(AzRendererPipelineContext<T> context, AzBone bone, class_630 sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        class_630.class_628 armorCube = (class_630.class_628)sourcePart.field_3663.getFirst();
        double armorBoneSizeX = firstCube.size().method_10216();
        double armorBoneSizeY = firstCube.size().method_10214();
        double armorBoneSizeZ = firstCube.size().method_10215();
        float actualArmorSizeX = Math.abs(armorCube.field_3648 - armorCube.field_3645);
        float actualArmorSizeY = Math.abs(armorCube.field_3647 - armorCube.field_3644);
        float actualArmorSizeZ = Math.abs(armorCube.field_3646 - armorCube.field_3643);
        float scaleX = (float)(armorBoneSizeX / (double)actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / (double)actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / (double)actualArmorSizeZ);
        sourcePart.method_2851(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.field_3654 = -bone.getRotX();
        sourcePart.field_3675 = -bone.getRotY();
        sourcePart.field_3674 = bone.getRotZ();
        context.poseStack().method_22905(scaleX, scaleY, scaleZ);
    }
}

