/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config;

import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.config.Configurable;
import mod.azure.azurelib.config.exception.ConfigValueMissingException;
import mod.azure.azurelib.config.io.ConfigIO;
import net.minecraft.client.gui.components.EditBox;
import org.jetbrains.annotations.Nullable;

public final class ConfigUtils {
    public static final char[] INTEGER_CHARS = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] DECIMAL_CHARS = new char[]{'-', '.', 'E', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final Pattern INTEGER_PATTERN = Pattern.compile("-?[0-9]+");
    public static final Pattern DECIMAL_PATTERN = Pattern.compile("-?[0-9]+(\\.[0-9]+)?(E[0-9]+)?");
    public static final Map<Class<?>, Class<?>> PRIMITIVE_MAPPINGS = new HashMap();

    public static void logCorrectedMessage(String field, @Nullable Object prevValue, Object corrected) {
        AzureLib.LOGGER.warn(ConfigIO.MARKER, "Correcting config value '{}' from '{}' to '{}'", (Object)field, (Object)Objects.toString(prevValue), corrected);
    }

    public static void logArraySizeCorrectedMessage(String field, Object prevValue, Object corrected) {
        AzureLib.LOGGER.warn(ConfigIO.MARKER, "Correcting config array value '{}' due to invalid size from '{}' to '{}'", (Object)field, prevValue, corrected);
    }

    public static boolean[] unboxArray(Boolean[] values) {
        boolean[] primitive = new boolean[values.length];
        int i = 0;
        Boolean[] booleanArray = values;
        int n = booleanArray.length;
        for (int j = 0; j < n; ++j) {
            boolean v = booleanArray[j];
            primitive[i++] = v;
        }
        return primitive;
    }

    public static int[] unboxArray(Integer[] values) {
        int[] primitive = new int[values.length];
        int i = 0;
        Integer[] integerArray = values;
        int n = integerArray.length;
        for (int j = 0; j < n; ++j) {
            int v = integerArray[j];
            primitive[i++] = v;
        }
        return primitive;
    }

    public static long[] unboxArray(Long[] values) {
        long[] primitive = new long[values.length];
        int i = 0;
        Long[] longArray = values;
        int n = longArray.length;
        for (int j = 0; j < n; ++j) {
            long v = longArray[j];
            primitive[i++] = v;
        }
        return primitive;
    }

    public static float[] unboxArray(Float[] values) {
        float[] primitive = new float[values.length];
        int i = 0;
        Float[] floatArray = values;
        int n = floatArray.length;
        for (int j = 0; j < n; ++j) {
            float v = floatArray[j].floatValue();
            primitive[i++] = v;
        }
        return primitive;
    }

    public static double[] unboxArray(Double[] values) {
        double[] primitive = new double[values.length];
        int i = 0;
        Double[] doubleArray = values;
        int n = doubleArray.length;
        for (int j = 0; j < n; ++j) {
            double v = doubleArray[j];
            primitive[i++] = v;
        }
        return primitive;
    }

    public static <E extends Enum<E>> E getEnumConstant(String value, Class<E> declaringClass) throws ConfigValueMissingException {
        Enum[] constants;
        for (Enum e : constants = (Enum[])declaringClass.getEnumConstants()) {
            if (!e.name().equals(value)) continue;
            return (E)e;
        }
        throw new ConfigValueMissingException("Missing enum value: " + value);
    }

    public static boolean containsOnlyValidCharacters(String in, char[] allowedChars) {
        char[] arr;
        for (char c : arr = in.toCharArray()) {
            boolean valid = false;
            for (char validate : allowedChars) {
                if (validate != c) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            return false;
        }
        return true;
    }

    public static DecimalFormat getDecimalFormat(Field field) {
        Configurable.Gui.NumberFormat format = field.getAnnotation(Configurable.Gui.NumberFormat.class);
        if (format != null) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            return new DecimalFormat(format.value(), symbols);
        }
        return null;
    }

    public static Class<?> remapPrimitiveType(Class<?> type) {
        return PRIMITIVE_MAPPINGS.getOrDefault(type, type);
    }

    public static void adjustCharacterLimit(Field field, EditBox widget) {
        Configurable.Gui.CharacterLimit limit = field.getAnnotation(Configurable.Gui.CharacterLimit.class);
        if (limit != null) {
            widget.m_94199_(Math.max(limit.value(), 1));
        }
    }

    private ConfigUtils() {
        throw new UnsupportedOperationException();
    }

    static {
        PRIMITIVE_MAPPINGS.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_MAPPINGS.put(Character.class, Character.TYPE);
        PRIMITIVE_MAPPINGS.put(Byte.class, Byte.TYPE);
        PRIMITIVE_MAPPINGS.put(Short.class, Short.TYPE);
        PRIMITIVE_MAPPINGS.put(Integer.class, Integer.TYPE);
        PRIMITIVE_MAPPINGS.put(Long.class, Long.TYPE);
        PRIMITIVE_MAPPINGS.put(Float.class, Float.TYPE);
        PRIMITIVE_MAPPINGS.put(Double.class, Double.TYPE);
    }
}

