/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AzModelRenderer<T> {
    private final Matrix4f poseStateCache = new Matrix4f();
    private final Vector3f normalCache = new Vector3f();
    private final AzRendererPipeline<T> rendererPipeline;
    protected final AzLayerRenderer<T> layerRenderer;
    private final Vector4f poseStateTransformCache = new Vector4f();

    public AzModelRenderer(AzRendererPipeline<T> rendererPipeline, AzLayerRenderer<T> layerRenderer) {
        this.layerRenderer = layerRenderer;
        this.rendererPipeline = rendererPipeline;
    }

    protected void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        T animatable = context.animatable();
        AzBakedModel model = context.bakedModel();
        this.rendererPipeline.updateAnimatedTextureFrame(animatable);
        for (AzBone bone : model.getTopLevelBones()) {
            this.renderRecursively(context, bone, isReRender);
        }
        AzRendererConfig<T> config = this.rendererPipeline.config();
        config.renderEntry(context);
    }

    protected void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        poseStack.m_85836_();
        RenderUtils.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.m_85849_();
    }

    protected void renderCubesOfBone(AzRendererPipelineContext<T> context, AzBone bone) {
        if (bone.isHidden()) {
            return;
        }
        PoseStack poseStack = context.poseStack();
        for (GeoCube cube : bone.getCubes()) {
            poseStack.m_85836_();
            this.renderCube(context, cube);
            poseStack.m_85849_();
        }
    }

    protected void renderChildBones(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (AzBone childBone : bone.getChildBones()) {
            this.renderRecursively(context, childBone, isReRender);
        }
    }

    protected void renderCube(AzRendererPipelineContext<T> context, GeoCube cube) {
        PoseStack poseStack = context.poseStack();
        RenderUtils.translateToPivotPoint(poseStack, cube);
        RenderUtils.rotateMatrixAroundCube(poseStack, cube);
        RenderUtils.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.m_85850_().m_85864_();
        Matrix4f poseState = poseStack.m_85850_().m_85861_();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = quad.normal().m_122281_();
            normal.m_122249_(normalisedPoseState);
            RenderUtils.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(context, quad, poseState, normal);
        }
    }

    protected void createVerticesOfQuad(AzRendererPipelineContext<T> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        VertexConsumer buffer = context.vertexConsumer();
        int packedOverlay = context.packedOverlay();
        int packedLight = context.packedLight();
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = new Vector4f(position.m_122239_(), position.m_122260_(), position.m_122269_(), 1.0f);
            vector4f.m_123607_(poseState);
            buffer.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), context.red(), context.green(), context.blue(), context.alpha(), vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
        }
    }

    public boolean boneRenderOverride(PoseStack poseStack, AzBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        return false;
    }

    @Nullable
    public RenderType getRenderTypeOverrideForBone(AzBone bone, T animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        return null;
    }

    @Nullable
    public ResourceLocation getTextureOverrideForBone(AzBone bone, T animatable, float partialTick) {
        return null;
    }

    public void handleAnimation(AzAnimator<T> animator, T animatable, float partialTick) {
        animator.animate(animatable, partialTick);
    }
}

