/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AzAutoGlowingLayer<T>
implements AzRenderLayer<T> {
    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
        T animatable = context.animatable();
        AzRendererPipeline<T> renderPipeline = context.rendererPipeline();
        ResourceLocation textureLocation = renderPipeline.config().textureLocation(animatable);
        RenderType renderType = AutoGlowingTexture.getRenderType(textureLocation);
        T t = context.animatable();
        if (t instanceof Entity) {
            Entity entity = (Entity)t;
            boolean isInvisibleButVisibleToPlayer = entity.m_20145_() && !entity.m_20177_(ClientUtils.getClientPlayer());
            boolean shouldAppearGlowing = Minecraft.m_91087_().m_91314_(entity);
            if (isInvisibleButVisibleToPlayer) {
                renderType = RenderType.m_110491_((ResourceLocation)textureLocation);
            } else if (shouldAppearGlowing) {
                renderType = AutoGlowingTexture.getOutlineRenderType(textureLocation);
            }
        }
        if (context.renderType() != null) {
            RenderType prevRenderType = context.renderType();
            int prevPackedLight = context.packedLight();
            VertexConsumer prevVertexConsumer = context.vertexConsumer();
            context.setRenderType(renderType);
            context.setPackedLight(0xF00000);
            context.setVertexConsumer(context.multiBufferSource().m_6299_(renderType));
            renderPipeline.reRender(context);
            context.setRenderType(prevRenderType);
            context.setPackedLight(prevPackedLight);
            context.setVertexConsumer(prevVertexConsumer);
        }
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
    }
}

