/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.dispatch.command;

import java.util.function.UnaryOperator;
import mod.azure.azurelib.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.animation.dispatch.command.AzCommandBuilder;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerCancelAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerPlayAnimationSequenceAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerSetAnimationSpeedAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerSetEasingTypeAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerSetFreezeTickAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerSetRepeatTimesAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerSetReverseAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerSetStartTickOffsetAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.controller.AzControllerSetTransitionSpeedAction;
import mod.azure.azurelib.animation.dispatch.command.sequence.AzAnimationSequence;
import mod.azure.azurelib.animation.dispatch.command.sequence.AzAnimationSequenceBuilder;
import mod.azure.azurelib.animation.easing.AzEasingType;

public class AzControllerCommandBuilder
extends AzCommandBuilder {
    public AzControllerCommandBuilder append(AzCommand command) {
        this.actions.addAll(command.actions());
        return this;
    }

    public AzControllerCommandBuilder setEasingType(String controllerName, AzEasingType easingType) {
        this.actions.add(new AzControllerSetEasingTypeAction(controllerName, easingType));
        return this;
    }

    public AzControllerCommandBuilder setSpeed(String controllerName, float speed) {
        this.actions.add(new AzControllerSetAnimationSpeedAction(controllerName, speed));
        return this;
    }

    public AzControllerCommandBuilder setTransitionSpeed(String controllerName, float transitionSpeed) {
        this.actions.add(new AzControllerSetTransitionSpeedAction(controllerName, transitionSpeed));
        return this;
    }

    public AzControllerCommandBuilder setStartTickOffset(String controllerName, float tickOffset) {
        this.actions.add(new AzControllerSetStartTickOffsetAction(controllerName, tickOffset));
        return this;
    }

    public AzControllerCommandBuilder setFreezeTickOffset(String controllerName, float freezeTickOffset) {
        this.actions.add(new AzControllerSetFreezeTickAction(controllerName, freezeTickOffset));
        return this;
    }

    public AzControllerCommandBuilder setRepeatAmount(String controllerName, float repeatAmount) {
        this.actions.add(new AzControllerSetRepeatTimesAction(controllerName, repeatAmount));
        return this;
    }

    public AzControllerCommandBuilder setReverseAnimation(String controllerName, boolean hasReverse) {
        this.actions.add(new AzControllerSetReverseAction(controllerName, hasReverse));
        return this;
    }

    public AzControllerCommandBuilder cancel(String controllerName) {
        this.actions.add(new AzControllerCancelAction(controllerName));
        return this;
    }

    public AzControllerCommandBuilder play(String controllerName, String animationName) {
        return this.playSequence(controllerName, builder -> builder.queue(animationName, properties -> properties));
    }

    public AzControllerCommandBuilder playSequence(String controllerName, UnaryOperator<AzAnimationSequenceBuilder> builderUnaryOperator) {
        AzAnimationSequence sequence = ((AzAnimationSequenceBuilder)builderUnaryOperator.apply(new AzAnimationSequenceBuilder())).build();
        this.actions.add(new AzControllerPlayAnimationSequenceAction(controllerName, sequence));
        return this;
    }
}

