/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.model;

import com.mojang.math.Vector3f;
import mod.azure.azurelib.model.AzBone;

public class AzBoneSnapshot {
    private final AzBone bone;
    private final Vector3f offsetPosition;
    private final Vector3f rotation;
    private final Vector3f scale;
    private double lastResetRotationTick = 0.0;
    private double lastResetPositionTick = 0.0;
    private double lastResetScaleTick = 0.0;
    private boolean rotAnimInProgress = true;
    private boolean posAnimInProgress = true;
    private boolean scaleAnimInProgress = true;

    public AzBoneSnapshot(AzBone bone) {
        this.bone = bone;
        this.offsetPosition = new Vector3f(bone.getPosX(), bone.getPosY(), bone.getPosZ());
        this.rotation = new Vector3f(bone.getRotX(), bone.getRotY(), bone.getRotZ());
        this.scale = new Vector3f(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static AzBoneSnapshot copy(AzBoneSnapshot snapshot) {
        AzBoneSnapshot newSnapshot = new AzBoneSnapshot(snapshot.bone);
        newSnapshot.offsetPosition.m_122245_(snapshot.offsetPosition.m_122239_(), snapshot.offsetPosition.m_122260_(), snapshot.offsetPosition.m_122269_());
        newSnapshot.rotation.m_122245_(snapshot.rotation.m_122239_(), snapshot.rotation.m_122260_(), snapshot.rotation.m_122269_());
        newSnapshot.scale.m_122245_(snapshot.scale.m_122239_(), snapshot.scale.m_122260_(), snapshot.scale.m_122269_());
        return newSnapshot;
    }

    public AzBone getBone() {
        return this.bone;
    }

    public float getScaleX() {
        return this.scale.f_122228_;
    }

    public float getScaleY() {
        return this.scale.f_122229_;
    }

    public float getScaleZ() {
        return this.scale.f_122230_;
    }

    public float getOffsetX() {
        return this.offsetPosition.f_122228_;
    }

    public float getOffsetY() {
        return this.offsetPosition.f_122229_;
    }

    public float getOffsetZ() {
        return this.offsetPosition.f_122230_;
    }

    public float getRotX() {
        return this.rotation.f_122228_;
    }

    public float getRotY() {
        return this.rotation.f_122229_;
    }

    public float getRotZ() {
        return this.rotation.f_122230_;
    }

    public double getLastResetRotationTick() {
        return this.lastResetRotationTick;
    }

    public double getLastResetPositionTick() {
        return this.lastResetPositionTick;
    }

    public double getLastResetScaleTick() {
        return this.lastResetScaleTick;
    }

    public boolean isRotAnimInProgress() {
        return this.rotAnimInProgress;
    }

    public boolean isPosAnimInProgress() {
        return this.posAnimInProgress;
    }

    public boolean isScaleAnimInProgress() {
        return this.scaleAnimInProgress;
    }

    public void updateScale(float scaleX, float scaleY, float scaleZ) {
        this.scale.m_122245_(scaleX, scaleY, scaleZ);
    }

    public void updateOffset(float offsetX, float offsetY, float offsetZ) {
        this.offsetPosition.m_122245_(offsetX, offsetY, offsetZ);
    }

    public void updateRotation(float rotX, float rotY, float rotZ) {
        this.rotation.m_122245_(rotX, rotY, rotZ);
    }

    public void startPosAnim() {
        this.posAnimInProgress = true;
    }

    public void stopPosAnim(double tick) {
        this.posAnimInProgress = false;
        this.lastResetPositionTick = tick;
    }

    public void startRotAnim() {
        this.rotAnimInProgress = true;
    }

    public void stopRotAnim(double tick) {
        this.rotAnimInProgress = false;
        this.lastResetRotationTick = tick;
    }

    public void startScaleAnim() {
        this.scaleAnimInProgress = true;
    }

    public void stopScaleAnim(double tick) {
        this.scaleAnimInProgress = false;
        this.lastResetScaleTick = tick;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.bone.getName().hashCode();
    }
}

