/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.armor;

import java.util.UUID;
import mod.azure.azurelib.animation.impl.AzItemAnimator;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.render.AzProvider;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.render.armor.AzArmorRendererPipeline;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AzArmorRenderer {
    private Entity entity;
    private final AzProvider<UUID, ItemStack> provider = new AzProvider<UUID, ItemStack>(config::createAnimator, config::modelLocation, animator -> {
        if (animator.m_41783_() != null && animator.m_41783_().m_128441_("az_id")) {
            animator.m_41783_().m_128342_("az_id");
        }
        return UUID.randomUUID();
    });
    private final AzArmorRendererPipeline rendererPipeline;
    @Nullable
    private AzItemAnimator reusedAzItemAnimator;

    public AzArmorRenderer(AzArmorRendererConfig config) {
        this.rendererPipeline = this.createPipeline(config);
    }

    protected AzArmorRendererPipeline createPipeline(AzRendererConfig config) {
        return new AzArmorRendererPipeline(config, this);
    }

    public void prepForRender(@Nullable Entity entity, ItemStack stack, @Nullable EquipmentSlot slot, @Nullable HumanoidModel<?> baseModel) {
        if (entity == null || slot == null || baseModel == null) {
            return;
        }
        this.entity = entity;
        this.rendererPipeline.context().prepare(entity, stack, slot, baseModel);
        AzBakedModel model = this.provider.provideBakedModel(entity, stack);
        this.prepareAnimator(stack, model);
    }

    private void prepareAnimator(ItemStack stack, AzBakedModel model) {
        this.reusedAzItemAnimator = (AzItemAnimator)this.provider.provideAnimator(this.entity, stack);
    }

    @Nullable
    public AzItemAnimator animator() {
        return this.reusedAzItemAnimator;
    }

    public AzProvider<UUID, ItemStack> provider() {
        return this.provider;
    }

    public AzArmorRendererPipeline rendererPipeline() {
        return this.rendererPipeline;
    }
}

