/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.block;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.block.AzBlockEntityModelRenderer;
import mod.azure.azurelib.render.block.AzBlockEntityRendererPipeline;
import mod.azure.azurelib.render.block.AzBlockEntityRendererPipelineContext;
import mod.azure.azurelib.render.layer.AzRenderLayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class AzBlockEntityRendererConfig<T extends BlockEntity>
extends AzRendererConfig<Long, T> {
    private AzBlockEntityRendererConfig(Supplier<AzAnimator<Long, T>> animatorProvider, Function<T, ResourceLocation> modelLocationProvider, Function<T, RenderType> renderTypeFunction, List<AzRenderLayer<Long, T>> renderLayers, Function<AzRendererPipelineContext<Long, T>, AzRendererPipelineContext<Long, T>> preRenderEntry, Function<AzRendererPipelineContext<Long, T>, AzRendererPipelineContext<Long, T>> renderEntry, Function<AzRendererPipelineContext<Long, T>, AzRendererPipelineContext<Long, T>> postRenderEntry, Function<T, ResourceLocation> textureLocationProvider, Function<T, Float> alphaFunction, Function<T, Float> scaleHeight, Function<T, Float> scaleWidth, BiFunction<AzRendererPipeline<Long, T>, AzLayerRenderer<Long, T>, AzModelRenderer<Long, T>> modelRendererProvider, Function<AzRendererPipeline<Long, T>, AzRendererPipelineContext<Long, T>> pipelineContextFunction, Function<AzBone, ResourceLocation> boneTextureOverrideProvider, Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
        super(animatorProvider, (Entity a, T b) -> (ResourceLocation)modelLocationProvider.apply(b), modelRendererProvider, pipelineContextFunction, (Entity a, T b) -> (RenderType)renderTypeFunction.apply(b), renderLayers, preRenderEntry, renderEntry, postRenderEntry, (Entity a, T b) -> (ResourceLocation)textureLocationProvider.apply(b), alphaFunction, scaleHeight, scaleWidth, boneTextureOverrideProvider, boneRenderTypeOverrideProvider);
    }

    public static <T extends BlockEntity> Builder<T> builder(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        return new Builder<BlockEntity>($ -> modelLocation, $ -> textureLocation);
    }

    public static <T extends BlockEntity> Builder<T> builder(Function<T, ResourceLocation> modelLocationProvider, Function<T, ResourceLocation> textureLocationProvider) {
        return new Builder<T>(modelLocationProvider, textureLocationProvider);
    }

    public static class Builder<T extends BlockEntity>
    extends AzRendererConfig.Builder<Long, T> {
        protected Builder(Function<T, ResourceLocation> modelLocationProvider, Function<T, ResourceLocation> textureLocationProvider) {
            super((Entity a, T b) -> (ResourceLocation)modelLocationProvider.apply(b), (Entity a, T b) -> (ResourceLocation)textureLocationProvider.apply(b));
            this.modelRendererProvider = (entityRendererPipeline, layer) -> new AzBlockEntityModelRenderer((AzBlockEntityRendererPipeline)entityRendererPipeline, layer);
            this.pipelineContextFunction = AzBlockEntityRendererPipelineContext::new;
            this.renderTypeProvider = (a, b) -> RenderType.m_110473_((ResourceLocation)((ResourceLocation)textureLocationProvider.apply(b)));
        }

        public Builder<T> setBoneRenderTypeOverrideProvider(Function<AzBone, RenderType> boneRenderTypeOverrideProvider) {
            return (Builder)super.setBoneRenderTypeOverrideProvider(boneRenderTypeOverrideProvider);
        }

        public Builder<T> setBoneTextureOverrideProvider(Function<AzBone, ResourceLocation> boneTextureOverrideProvider) {
            return (Builder)super.setBoneTextureOverrideProvider(boneTextureOverrideProvider);
        }

        public Builder<T> setModelRenderer(BiFunction<AzRendererPipeline<Long, T>, AzLayerRenderer<Long, T>, AzModelRenderer<Long, T>> modelRendererProvider) {
            return (Builder)super.setModelRenderer(modelRendererProvider);
        }

        public Builder<T> setPipelineContext(Function<AzRendererPipeline<Long, T>, AzRendererPipelineContext<Long, T>> pipelineContextFunction) {
            return (Builder)super.setPipelineContext(pipelineContextFunction);
        }

        public Builder<T> addRenderLayer(AzRenderLayer<Long, T> renderLayer) {
            return (Builder)super.addRenderLayer(renderLayer);
        }

        public Builder<T> setRenderType(RenderType renderType) {
            this.renderTypeProvider = (a, b) -> renderType;
            return this;
        }

        public Builder<T> setRenderType(Function<T, RenderType> renderTypeProvider) {
            this.renderTypeProvider = (a, b) -> (RenderType)renderTypeProvider.apply(b);
            return this;
        }

        public Builder<T> setRenderType(BiFunction<Entity, T, RenderType> renderTypeProvider) {
            this.renderTypeProvider = renderTypeProvider;
            return this;
        }

        public Builder<T> setPrerenderEntry(Function<AzRendererPipelineContext<Long, T>, AzRendererPipelineContext<Long, T>> preRenderEntry) {
            return (Builder)super.setPrerenderEntry(preRenderEntry);
        }

        public Builder<T> setRenderEntry(Function<AzRendererPipelineContext<Long, T>, AzRendererPipelineContext<Long, T>> renderEntry) {
            return (Builder)super.setRenderEntry(renderEntry);
        }

        public Builder<T> setPostRenderEntry(Function<AzRendererPipelineContext<Long, T>, AzRendererPipelineContext<Long, T>> preRenderEntry) {
            return (Builder)super.setPostRenderEntry(preRenderEntry);
        }

        public Builder<T> setAnimatorProvider(Supplier<@Nullable AzAnimator<Long, T>> animatorProvider) {
            return (Builder)super.setAnimatorProvider(animatorProvider);
        }

        public Builder<T> setAlpha(Function<T, Float> alphaFunction) {
            return (Builder)super.setAlpha(alphaFunction);
        }

        public Builder<T> setAlpha(float alpha) {
            return (Builder)super.setAlpha(alpha);
        }

        public Builder<T> setScale(Function<T, Float> scaleFunction) {
            return (Builder)super.setScale(scaleFunction);
        }

        public Builder<T> setScale(Function<T, Float> scaleHeightFunction, Function<T, Float> scaleWidthFunction) {
            return (Builder)super.setScale(scaleHeightFunction, scaleWidthFunction);
        }

        public Builder<T> setScale(float scale) {
            return (Builder)super.setScale(scale);
        }

        public Builder<T> setScale(float scaleWidth, float scaleHeight) {
            return (Builder)super.setScale(scaleWidth, scaleHeight);
        }

        public AzBlockEntityRendererConfig<T> build() {
            AzRendererConfig baseConfig = super.build();
            return new AzBlockEntityRendererConfig<BlockEntity>(baseConfig::createAnimator, baseConfig::modelLocation, baseConfig::getRenderType, baseConfig.renderLayers(), baseConfig::preRenderEntry, baseConfig::renderEntry, baseConfig::postRenderEntry, baseConfig::textureLocation, baseConfig::alpha, baseConfig::scaleHeight, baseConfig::scaleWidth, baseConfig::modelRendererProvider, baseConfig::pipelineContext, baseConfig::boneTextureOverrideProvider, baseConfig::boneRenderTypeOverrideProvider);
        }
    }
}

