/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.UUID;
import java.util.stream.Stream;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.item.AzItemModelRenderer;
import mod.azure.azurelib.render.item.AzItemRenderer;
import mod.azure.azurelib.render.item.AzItemRendererConfig;
import mod.azure.azurelib.render.item.AzItemRendererPipelineContext;
import net.minecraft.world.item.ItemStack;

public class AzItemRendererPipeline
extends AzRendererPipeline<UUID, ItemStack> {
    private final AzItemRenderer itemRenderer;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzItemRendererPipeline(AzItemRendererConfig config, AzItemRenderer itemRenderer) {
        super(config);
        this.itemRenderer = itemRenderer;
    }

    @Override
    protected AzRendererPipelineContext<UUID, ItemStack> createContext(AzRendererPipeline<UUID, ItemStack> rendererPipeline) {
        return this.config.pipelineContext(this);
    }

    protected AzItemModelRenderer createModelRenderer(AzLayerRenderer<UUID, ItemStack> layerRenderer) {
        return (AzItemModelRenderer)this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<UUID, ItemStack> createLayerRenderer(AzRendererConfig<UUID, ItemStack> config) {
        return new AzLayerRenderer<UUID, ItemStack>(config::renderLayers);
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, ItemStack> context, boolean isReRender) {
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        PoseStack poseStack = context.poseStack();
        this.itemRenderTranslations = new Matrix4f(poseStack.m_85850_().m_85861_());
        AzItemRendererConfig config = this.itemRenderer.config();
        float scaleWidth = config.scaleWidth(context.animatable());
        float scaleHeight = config.scaleHeight(context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (!isReRender) {
            boolean useNewOffset = config.useNewOffset();
            poseStack.m_85837_(0.5, useNewOffset ? 0.0 : (double)0.51f, 0.5);
        }
        Stream.of("leftArm", "rightArm").forEach(boneName -> context.bakedModel().getBone((String)boneName).ifPresent(bone -> {
            bone.setHidden(true);
            bone.setChildrenHidden(false);
        }));
        if (config.alpha(context.animatable()) < 1.0f) {
            itemContext.setAlpha(config.alpha(context.animatable()));
            itemContext.setTranslucent(true);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<UUID, ItemStack> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    @Override
    public void updateAnimatedTextureFrame(ItemStack animatable) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), animatable));
    }

    public AzItemRenderer getRenderer() {
        return this.itemRenderer;
    }
}

