/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util;

import mod.azure.azurelib.blocks.TickingLightEntity;
import mod.azure.azurelib.registry.AzureBlocksRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class AzureLibUtil {
    public static <T> T self(Object object) {
        return (T)object;
    }

    public static boolean isMultipleOf(int p_265754_, int p_265543_) {
        return p_265754_ % p_265543_ == 0;
    }

    public static void summonAoE(LivingEntity entity, ParticleOptions particle, int yOffset, int duration, float radius, boolean hasEffect, @Nullable MobEffect effect, int effectTime) {
        AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(entity.f_19853_, entity.m_20185_(), entity.m_20186_() + (double)yOffset, entity.m_20189_());
        areaEffectCloudEntity.m_19712_(radius);
        areaEffectCloudEntity.m_19734_(duration);
        areaEffectCloudEntity.m_19724_(particle);
        areaEffectCloudEntity.m_19738_(-areaEffectCloudEntity.m_19743_() / (float)areaEffectCloudEntity.m_19748_());
        if (hasEffect && !entity.m_21023_(effect)) {
            areaEffectCloudEntity.m_19716_(new MobEffectInstance(effect, effectTime, 0));
        }
        entity.f_19853_.m_7967_((Entity)areaEffectCloudEntity);
    }

    public static void spawnLightSource(Entity entity, boolean isInWaterBlock) {
        BlockEntity blockEntity;
        BlockPos lightBlockPos = null;
        if (lightBlockPos == null) {
            lightBlockPos = AzureLibUtil.findFreeSpace(entity.f_19853_, entity.m_20183_());
            if (lightBlockPos == null) {
                return;
            }
            entity.f_19853_.m_46597_(lightBlockPos, AzureBlocksRegistry.TICKING_LIGHT_BLOCK.get().m_49966_());
        } else if (AzureLibUtil.checkDistance(lightBlockPos, entity.m_20183_()) && (blockEntity = entity.f_19853_.m_7702_(lightBlockPos)) instanceof TickingLightEntity) {
            TickingLightEntity tickingLightEntity = (TickingLightEntity)blockEntity;
            tickingLightEntity.refresh(isInWaterBlock ? 20 : 0);
        }
    }

    private static boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= 2 && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= 2 && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= 2;
    }

    private static BlockPos findFreeSpace(Level world, BlockPos blockPos) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[5];
        offsets[0] = 0;
        for (int i = 2; i <= 4; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals((Object)AzureBlocksRegistry.TICKING_LIGHT_BLOCK.get())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }
}

