/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animatable;

import com.google.common.base.Suppliers;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.azure.azurelib.animatable.SingletonGeoAnimatable;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.cache.AnimatableIdCache;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.ContextAwareAnimatableManager;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLLoader;

@Deprecated
public interface GeoItem
extends SingletonGeoAnimatable {
    public static final String ID_NBT_KEY = "AzureLibID";

    public static Supplier<RenderProvider> makeRenderer(GeoItem item) {
        if (FMLLoader.getDist().isDedicatedServer()) {
            return () -> null;
        }
        return Suppliers.memoize(() -> {
            AtomicReference renderProvider = new AtomicReference();
            item.createRenderer(renderProvider::set);
            return (RenderProvider)renderProvider.get();
        });
    }

    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        SingletonGeoAnimatable.registerSyncedAnimatable(animatable);
    }

    public static long getId(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return Long.MAX_VALUE;
        }
        return tag.func_74763_f(ID_NBT_KEY);
    }

    public static long getOrAssignId(ItemStack stack, ServerWorld level) {
        CompoundNBT tag = stack.func_196082_o();
        long id = tag.func_74763_f(ID_NBT_KEY);
        if (tag.func_150297_b(ID_NBT_KEY, 99)) {
            return id;
        }
        id = AnimatableIdCache.getFreeId(level);
        tag.func_74772_a(ID_NBT_KEY, id);
        return id;
    }

    @Override
    default public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    default public boolean isPerspectiveAware() {
        return false;
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        if (this.isPerspectiveAware()) {
            return new ContextBasedAnimatableInstanceCache(this);
        }
        return SingletonGeoAnimatable.super.animatableCacheOverride();
    }

    public static class ContextBasedAnimatableInstanceCache
    extends SingletonAnimatableInstanceCache {
        public ContextBasedAnimatableInstanceCache(GeoAnimatable animatable) {
            super(animatable);
        }

        @Override
        public AnimatableManager<?> getManagerForId(long uniqueId) {
            if (!this.managers.containsKey(uniqueId)) {
                this.managers.put(uniqueId, (Object)new ContextAwareAnimatableManager<GeoItem, ItemCameraTransforms.TransformType>(this.animatable){

                    @Override
                    protected Map<ItemCameraTransforms.TransformType, AnimatableManager<GeoItem>> buildContextOptions(GeoAnimatable animatable) {
                        EnumMap<ItemCameraTransforms.TransformType, AnimatableManager<GeoItem>> map = new EnumMap<ItemCameraTransforms.TransformType, AnimatableManager<GeoItem>>(ItemCameraTransforms.TransformType.class);
                        for (ItemCameraTransforms.TransformType context : ItemCameraTransforms.TransformType.values()) {
                            map.put(context, new AnimatableManager(animatable));
                        }
                        return map;
                    }

                    @Override
                    public ItemCameraTransforms.TransformType getCurrentContext() {
                        ItemCameraTransforms.TransformType context = this.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
                        return context == null ? ItemCameraTransforms.TransformType.NONE : context;
                    }
                });
            }
            return (AnimatableManager)this.managers.get(uniqueId);
        }
    }
}

