/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.AzureLibException;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.loading.FileLoader;
import mod.azure.azurelib.loading.json.raw.Model;
import mod.azure.azurelib.loading.object.BakedAnimations;
import mod.azure.azurelib.loading.object.BakedModelFactory;
import mod.azure.azurelib.loading.object.GeometryTree;
import mod.azure.azurelib.rewrite.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelib.rewrite.model.cache.AzBakedModelCache;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public final class AzureLibCache {
    private static final List<String> EXCLUDED_NAMESPACES = Arrays.asList("geckolib3", "animatedmobsmod", "moreplayermodels", "dungeons_mobs", "customnpcs", "gunsrpg", "mimic", "celestisynth", "the_flesh_that_hates", "enemyexpansion", "mutationcraft", "born_in_chaos_v1");
    private static Map<ResourceLocation, BakedAnimations> ANIMATIONS = Collections.emptyMap();
    private static Map<ResourceLocation, BakedGeoModel> MODELS = Collections.emptyMap();

    public static Map<ResourceLocation, BakedAnimations> getBakedAnimations() {
        if (!AzureLib.hasInitialized) {
            throw new AzureLibException("AzureLib was never initialized! Please read the documentation!");
        }
        return ANIMATIONS;
    }

    public static Map<ResourceLocation, BakedGeoModel> getBakedModels() {
        if (!AzureLib.hasInitialized) {
            throw new AzureLibException("AzureLib was never initialized! Please read the documentation!");
        }
        return MODELS;
    }

    public static void registerReloadListener() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        if (!(mc.func_195551_G() instanceof IReloadableResourceManager)) {
            throw new AzureLibException("AzureLib was initialized too early!");
        }
        IReloadableResourceManager reloadable = (IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
        reloadable.func_219534_a(AzureLibCache::reload);
    }

    private static CompletableFuture<Void> reload(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap models = new Object2ObjectOpenHashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[4];
        completableFutureArray[0] = AzureLibCache.loadAnimations(backgroundExecutor, resourceManager, ((Map)animations)::put);
        completableFutureArray[1] = AzureLibCache.loadModels(backgroundExecutor, resourceManager, ((Map)models)::put);
        completableFutureArray[2] = AzBakedAnimationCache.getInstance().loadAnimations(backgroundExecutor, resourceManager);
        completableFutureArray[3] = AzBakedModelCache.getInstance().loadModels(backgroundExecutor, resourceManager);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(arg_0 -> AzureLibCache.lambda$reload$0((Map)animations, (Map)models, arg_0), gameExecutor);
    }

    private static CompletableFuture<Void> loadAnimations(Executor backgroundExecutor, IResourceManager resourceManager, BiConsumer<ResourceLocation, BakedAnimations> elementConsumer) {
        return AzureLibCache.loadResources(backgroundExecutor, resourceManager, "animations", resource -> FileLoader.loadAnimationsFile(resource, resourceManager), elementConsumer);
    }

    private static CompletableFuture<Void> loadModels(Executor backgroundExecutor, IResourceManager resourceManager, BiConsumer<ResourceLocation, BakedGeoModel> elementConsumer) {
        return AzureLibCache.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            Model model = FileLoader.loadModelFile(resource, resourceManager);
            return BakedModelFactory.getForNamespace(resource.func_110624_b()).constructGeoModel(GeometryTree.fromModel(model));
        }, elementConsumer);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, IResourceManager resourceManager, String type, Function<ResourceLocation, T> loader, BiConsumer<ResourceLocation, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.func_199003_a(type, fileName -> fileName.endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (ResourceLocation resource : resources) {
                CompletableFuture<Object> existing = tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
                if (existing == null) continue;
                System.err.println("Duplicate resource for " + resource);
                existing.cancel(false);
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (EXCLUDED_NAMESPACES.contains(((ResourceLocation)entry.getKey()).func_110624_b().toLowerCase(Locale.ROOT))) continue;
                map.accept((ResourceLocation)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }

    private static /* synthetic */ void lambda$reload$0(Map animations, Map models, Void empty) {
        ANIMATIONS = animations;
        MODELS = models;
    }
}

