/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache.texture;

import com.mojang.blaze3d.systems.IRenderCall;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.resource.AzureAnimationMetadataSection;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;

public class AnimatableTexture
extends SimpleTexture {
    protected AnimationContents animationContents = null;
    protected boolean isAnimated = false;

    public AnimatableTexture(ResourceLocation location) {
        super(location);
    }

    public static void setAndUpdate(ResourceLocation texturePath) {
        AnimatableTexture.setAndUpdate(texturePath, (int)RenderUtils.getCurrentTick());
    }

    public static void setAndUpdate(ResourceLocation texturePath, int frameTick) {
        Texture texture = Minecraft.func_71410_x().func_110434_K().func_229267_b_(texturePath);
        if (texture instanceof AnimatableTexture) {
            ((AnimatableTexture)texture).setAnimationFrame(frameTick);
        }
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        IResource resource = manager.func_199002_a(this.field_110568_b);
        AnimationMetadataSection animMeta = (AnimationMetadataSection)resource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
        if (animMeta != null) {
            NativeImage nativeImage;
            try (InputStream inputstream = resource.func_199027_b();){
                nativeImage = NativeImage.func_195713_a((InputStream)inputstream);
            }
            this.animationContents = new AnimationContents(nativeImage, (AzureAnimationMetadataSection)animMeta);
            if (!this.animationContents.isValid()) {
                nativeImage.close();
                return;
            }
            this.isAnimated = true;
            AnimatableTexture.onRenderThread(() -> {
                TextureUtil.func_225681_a_((int)this.func_110552_b(), (int)0, (int)((Integer)this.animationContents.frameSize.getFirst()), (int)((Integer)this.animationContents.frameSize.getSecond()));
                nativeImage.func_227788_a_(0, 0, 0, 0, 0, ((Integer)this.animationContents.frameSize.getFirst()).intValue(), ((Integer)this.animationContents.frameSize.getSecond()).intValue(), false, false);
            });
        }
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    private static void onRenderThread(IRenderCall renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((IRenderCall)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected class AnimationContents {
        protected final Pair<Integer, Integer> frameSize;
        protected final Texture animatedTexture;

        private AnimationContents(NativeImage image, AzureAnimationMetadataSection animMeta) {
            this.frameSize = animMeta.func_229304_c_(image.func_195702_a(), image.func_195714_b());
            this.animatedTexture = this.generateAnimatedTexture(image, animMeta);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        private Texture generateAnimatedTexture(NativeImage image, AzureAnimationMetadataSection animMeta) {
            if (!AzureLibUtil.isMultipleOf(image.func_195702_a(), (Integer)this.frameSize.getFirst()) || !AzureLibUtil.isMultipleOf(image.func_195714_b(), (Integer)this.frameSize.getSecond())) {
                AzureLib.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)AnimatableTexture.this.field_110568_b, (Object)image.func_195702_a(), (Object)image.func_195714_b(), this.frameSize.getFirst(), this.frameSize.getSecond());
                return null;
            }
            int columns = image.func_195702_a() / (Integer)this.frameSize.getFirst();
            int rows = image.func_195714_b() / (Integer)this.frameSize.getSecond();
            int frameCount = columns * rows;
            ObjectArrayList frames = new ObjectArrayList();
            animMeta.forEachFrame((arg_0, arg_1) -> this.lambda$generateAnimatedTexture$0((List)frames, arg_0, arg_1));
            if (frames.isEmpty()) {
                for (int frame = 0; frame < frameCount; ++frame) {
                    frames.add(new Frame(frame, animMeta.getDefaultFrameTime()));
                }
            } else {
                int index = 0;
                IntOpenHashSet unusedFrames = new IntOpenHashSet();
                for (Frame frame : frames) {
                    if (frame.time <= 0) {
                        AzureLib.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)AnimatableTexture.this.field_110568_b, (Object)index, (Object)frame.time);
                        unusedFrames.add(frame.index);
                    } else if (frame.index < 0 || frame.index >= frameCount) {
                        AzureLib.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)AnimatableTexture.this.field_110568_b, (Object)index, (Object)frame.index);
                        unusedFrames.add(frame.index);
                    }
                    ++index;
                }
                if (!unusedFrames.isEmpty()) {
                    AzureLib.LOGGER.warn("Unused frames in sprite {}: {}", (Object)AnimatableTexture.this.field_110568_b, (Object)Arrays.toString(unusedFrames.toArray()));
                }
            }
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.isInterpolatedFrames());
        }

        private /* synthetic */ void lambda$generateAnimatedTexture$0(List frames, int frame, int frameTime) {
            frames.add(new Frame(frame, frameTime));
        }

        protected class Texture
        implements AutoCloseable {
            protected final NativeImage baseImage;
            protected final Frame[] frames;
            protected final int framePanelSize;
            protected final boolean interpolating;
            protected final NativeImage interpolatedFrame;
            protected final int totalFrameTime;
            protected int glowMaskTextureId = -1;
            protected NativeImage glowmaskImage = null;
            protected NativeImage glowmaskInterpolatedFrame = null;
            protected int currentFrame;
            protected int currentSubframe;

            private Texture(NativeImage baseImage, Frame[] frames, int framePanelSize, boolean interpolating) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new NativeImage(((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false) : null;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time;
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            private int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setGlowMaskTexture(AutoGlowingTexture texture, NativeImage baseImage, NativeImage glowMask) {
                this.glowMaskTextureId = texture.func_110552_b();
                this.glowmaskImage = glowMask;
                this.glowmaskInterpolatedFrame = this.interpolating ? new NativeImage(((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false) : null;
                this.baseImage.func_195703_a(baseImage);
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time += frame.time)) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = ticks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    AnimatableTexture.onRenderThread(() -> {
                        TextureUtil.func_225681_a_((int)AnimatableTexture.this.func_110552_b(), (int)0, (int)((Integer)AnimationContents.this.frameSize.getFirst()), (int)((Integer)AnimationContents.this.frameSize.getSecond()));
                        this.baseImage.func_227788_a_(0, 0, 0, this.getFrameX(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getFirst(), this.getFrameY(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getSecond(), ((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false, false);
                    });
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    AnimatableTexture.onRenderThread(this::generateInterpolatedFrame);
                }
            }

            private void generateInterpolatedFrame() {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time;
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < this.interpolatedFrame.func_195714_b(); ++y) {
                        for (int x = 0; x < this.interpolatedFrame.func_195702_a(); ++x) {
                            int prevFramePixel = this.getPixel(frame.index, x, y);
                            int nextFramePixel = this.getPixel(nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            this.interpolatedFrame.func_195700_a(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    TextureUtil.func_225681_a_((int)AnimatableTexture.this.func_110552_b(), (int)0, (int)((Integer)AnimationContents.this.frameSize.getFirst()), (int)((Integer)AnimationContents.this.frameSize.getSecond()));
                    this.interpolatedFrame.func_227788_a_(0, 0, 0, 0, 0, ((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false, false);
                }
            }

            private int getPixel(int frameIndex, int x, int y) {
                return this.baseImage.func_195709_a(x + this.getFrameX(frameIndex) * (Integer)AnimationContents.this.frameSize.getFirst(), y + this.getFrameY(frameIndex) * (Integer)AnimationContents.this.frameSize.getSecond());
            }

            private int interpolate(double frameProgress, double prevColour, double nextColour) {
                return (int)(frameProgress * prevColour + (1.0 - frameProgress) * nextColour);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
            }
        }

        private class Frame {
            int index;
            int time;

            public Frame(int index, int time) {
                this.index = index;
                this.time = time;
            }
        }
    }
}

