/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache.texture;

import com.mojang.blaze3d.systems.IRenderCall;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.cache.texture.GeoAbstractTexture;
import mod.azure.azurelib.resource.GeoGlowingTextureMeta;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final String APPENDIX = "_glowmask";
    protected final ResourceLocation textureBase;
    protected final ResourceLocation glowLayer;

    public AutoGlowingTexture(ResourceLocation originalLocation, ResourceLocation location) {
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    protected static ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.func_229263_a_(path, (Texture)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    @Nullable
    protected IRenderCall loadTexture(IResourceManager resourceManager, Minecraft mc) throws IOException {
        boolean animated;
        Texture originalTexture;
        try {
            originalTexture = (Texture)mc.func_213169_a(() -> mc.func_110434_K().func_229267_b_(this.textureBase)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException("Failed to load original texture: " + this.textureBase, e);
        }
        IResource textureBaseResource = resourceManager.func_199002_a(this.textureBase);
        NativeImage baseImage = originalTexture instanceof DynamicTexture ? ((DynamicTexture)originalTexture).func_195414_e() : NativeImage.func_195713_a((InputStream)textureBaseResource.func_199027_b());
        NativeImage glowImage = null;
        TextureMetadataSection textureBaseMeta = (TextureMetadataSection)textureBaseResource.func_199028_a((IMetadataSectionSerializer)TextureMetadataSection.field_195819_a);
        boolean blur = textureBaseMeta != null && textureBaseMeta.func_110479_a();
        boolean clamp = textureBaseMeta != null && textureBaseMeta.func_110480_b();
        try {
            IResource glowLayerResource = resourceManager.func_199002_a(this.glowLayer);
            GeoGlowingTextureMeta glowLayerMeta = null;
            if (glowLayerResource != null) {
                glowImage = NativeImage.func_195713_a((InputStream)glowLayerResource.func_199027_b());
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            } else {
                GeoGlowingTextureMeta meta = (GeoGlowingTextureMeta)textureBaseResource.func_199028_a(GeoGlowingTextureMeta.DESERIALIZER);
                if (meta != null) {
                    glowLayerMeta = meta;
                    glowImage = new NativeImage(baseImage.func_195702_a(), baseImage.func_195714_b(), true);
                }
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                if (!FMLEnvironment.production) {
                    this.printDebugImageToDisk(this.textureBase, baseImage);
                    this.printDebugImageToDisk(this.glowLayer, glowImage);
                }
            }
        }
        catch (IOException e) {
            AzureLib.LOGGER.warn("Resource failed to open for glowlayer meta: {}", (Object)this.glowLayer, (Object)e);
        }
        NativeImage mask = glowImage;
        if (mask == null) {
            String expectedGlowmask = this.textureBase.toString().replace(".png", "_glowmask.png");
            AzureLib.LOGGER.warn("Missing glowmask texture. Base texture: {}, Expected glowmask: {}", (Object)this.textureBase, (Object)expectedGlowmask);
            return null;
        }
        boolean bl = animated = originalTexture instanceof AnimatableTexture && ((AnimatableTexture)originalTexture).isAnimated();
        if (animated) {
            ((AnimatableTexture)originalTexture).animationContents.animatedTexture.setGlowMaskTexture(this, baseImage, mask);
        }
        return () -> {
            if (!animated) {
                AutoGlowingTexture.uploadSimple(this.func_110552_b(), mask, blur, clamp);
            }
            if (originalTexture instanceof DynamicTexture) {
                ((DynamicTexture)originalTexture).func_110564_a();
            } else {
                AutoGlowingTexture.uploadSimple(originalTexture.func_110552_b(), baseImage, blur, clamp);
            }
        };
    }

    public static RenderType getRenderType(ResourceLocation texture) {
        return GlowRenderType.emissive(AutoGlowingTexture.getEmissiveResource(texture), false);
    }

    public static RenderType getOutlineRenderType(ResourceLocation texture) {
        return GlowRenderType.emissive(AutoGlowingTexture.getEmissiveResource(texture), true);
    }

    static class GlowRenderType
    extends RenderType {
        public GlowRenderType(String p_i225992_1_, VertexFormat p_i225992_2_, int p_i225992_3_, int p_i225992_4_, boolean p_i225992_5_, boolean p_i225992_6_, Runnable p_i225992_7_, Runnable p_i225992_8_) {
            super(p_i225992_1_, p_i225992_2_, p_i225992_3_, p_i225992_4_, p_i225992_5_, p_i225992_6_, p_i225992_7_, p_i225992_8_);
        }

        public static RenderType emissive(ResourceLocation texture, boolean isGlowing) {
            return RenderType.func_228632_a_((String)"az_glowing_layer", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228713_a_(RenderState.field_228517_i_).func_228714_a_(new RenderState.CullState(false)).func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228726_a_(RenderState.field_228515_g_).func_228722_a_(new RenderState.OverlayState(true)).func_228728_a_(isGlowing));
        }
    }
}

