/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.core.animation;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreBakedGeoModel;
import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.core.animatable.model.CoreGeoModel;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.animation.EasingType;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.keyframe.AnimationPoint;
import mod.azure.azurelib.core.keyframe.BoneAnimationQueue;
import mod.azure.azurelib.core.state.BoneSnapshot;
import mod.azure.azurelib.core.utils.Interpolations;

@Deprecated
public class AnimationProcessor<T extends GeoAnimatable> {
    private final Map<String, CoreGeoBone> bones = new Object2ObjectOpenHashMap();
    private final CoreGeoModel<T> model;
    public boolean reloadAnimations = false;

    public AnimationProcessor(CoreGeoModel<T> model) {
        this.model = model;
    }

    public Queue<QueuedAnimation> buildAnimationQueue(T animatable, RawAnimation rawAnimation) {
        LinkedList<QueuedAnimation> animations = new LinkedList<QueuedAnimation>();
        boolean error = false;
        for (RawAnimation.Stage stage : rawAnimation.getAnimationStages()) {
            Animation animation = stage.animationName() == "internal.wait" ? Animation.generateWaitAnimation(stage.additionalTicks()) : this.model.getAnimation(animatable, stage.animationName());
            if (animation == null) {
                System.out.println("Unable to find animation: " + stage.animationName() + " for " + animatable.getClass().getSimpleName());
                error = true;
                continue;
            }
            animations.add(new QueuedAnimation(animation, stage.loopType()));
        }
        return error ? null : animations;
    }

    public void tickAnimation(T animatable, CoreGeoModel<T> model, AnimatableManager<T> animatableManager, double animTime, AnimationState<T> event, boolean crashWhenCantFindBone) {
        Map<String, BoneSnapshot> boneSnapshots = this.updateBoneSnapshots(animatableManager.getBoneSnapshotCollection());
        for (AnimationController<T> controller : animatableManager.getAnimationControllers().values()) {
            if (this.reloadAnimations) {
                controller.forceAnimationReset();
                controller.getBoneAnimationQueues().clear();
            }
            controller.isJustStarting = animatableManager.isFirstTick();
            event.withController(controller);
            controller.process(model, event, this.bones, boneSnapshots, animTime, crashWhenCantFindBone);
            for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues().values()) {
                CoreGeoBone bone = boneAnimation.bone();
                BoneSnapshot snapshot = boneSnapshots.get(bone.getName());
                BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
                AnimationPoint rotXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                AnimationPoint rotYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                AnimationPoint rotZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                AnimationPoint posXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                AnimationPoint posYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                AnimationPoint posZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                AnimationPoint scaleXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                AnimationPoint scaleYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                AnimationPoint scaleZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                EasingType easingType = controller.overrideEasingTypeFunction.apply(animatable);
                if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
                    bone.setRotX((float)EasingType.lerpWithOverride(rotXPoint, easingType) + initialSnapshot.getRotX());
                    bone.setRotY((float)EasingType.lerpWithOverride(rotYPoint, easingType) + initialSnapshot.getRotY());
                    bone.setRotZ((float)EasingType.lerpWithOverride(rotZPoint, easingType) + initialSnapshot.getRotZ());
                    snapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    snapshot.startRotAnim();
                    bone.markRotationAsChanged();
                }
                if (posXPoint != null && posYPoint != null && posZPoint != null) {
                    bone.setPosX((float)EasingType.lerpWithOverride(posXPoint, easingType));
                    bone.setPosY((float)EasingType.lerpWithOverride(posYPoint, easingType));
                    bone.setPosZ((float)EasingType.lerpWithOverride(posZPoint, easingType));
                    snapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    snapshot.startPosAnim();
                    bone.markPositionAsChanged();
                }
                if (scaleXPoint == null || scaleYPoint == null || scaleZPoint == null) continue;
                bone.setScaleX((float)EasingType.lerpWithOverride(scaleXPoint, easingType));
                bone.setScaleY((float)EasingType.lerpWithOverride(scaleYPoint, easingType));
                bone.setScaleZ((float)EasingType.lerpWithOverride(scaleZPoint, easingType));
                snapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
                snapshot.startScaleAnim();
                bone.markScaleAsChanged();
            }
        }
        this.reloadAnimations = false;
        double resetTickLength = animatable.getBoneResetTime();
        for (CoreGeoBone bone : this.getRegisteredBones()) {
            double percentageReset;
            BoneSnapshot saveSnapshot;
            BoneSnapshot initialSnapshot;
            if (!bone.hasRotationChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isRotAnimInProgress()) {
                    saveSnapshot.stopRotAnim(animTime);
                }
                percentageReset = Math.min((animTime - saveSnapshot.getLastResetRotationTick()) / resetTickLength, 1.0);
                bone.setRotX((float)Interpolations.lerp((double)saveSnapshot.getRotX(), (double)initialSnapshot.getRotX(), percentageReset));
                bone.setRotY((float)Interpolations.lerp((double)saveSnapshot.getRotY(), (double)initialSnapshot.getRotY(), percentageReset));
                bone.setRotZ((float)Interpolations.lerp((double)saveSnapshot.getRotZ(), (double)initialSnapshot.getRotZ(), percentageReset));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                }
            }
            if (!bone.hasPositionChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isPosAnimInProgress()) {
                    saveSnapshot.stopPosAnim(animTime);
                }
                percentageReset = Math.min((animTime - saveSnapshot.getLastResetPositionTick()) / resetTickLength, 1.0);
                bone.setPosX((float)Interpolations.lerp((double)saveSnapshot.getOffsetX(), (double)initialSnapshot.getOffsetX(), percentageReset));
                bone.setPosY((float)Interpolations.lerp((double)saveSnapshot.getOffsetY(), (double)initialSnapshot.getOffsetY(), percentageReset));
                bone.setPosZ((float)Interpolations.lerp((double)saveSnapshot.getOffsetZ(), (double)initialSnapshot.getOffsetZ(), percentageReset));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                }
            }
            if (bone.hasScaleChanged()) continue;
            initialSnapshot = bone.getInitialSnapshot();
            saveSnapshot = boneSnapshots.get(bone.getName());
            if (saveSnapshot.isScaleAnimInProgress()) {
                saveSnapshot.stopScaleAnim(animTime);
            }
            percentageReset = Math.min((animTime - saveSnapshot.getLastResetScaleTick()) / resetTickLength, 1.0);
            bone.setScaleX((float)Interpolations.lerp((double)saveSnapshot.getScaleX(), (double)initialSnapshot.getScaleX(), percentageReset));
            bone.setScaleY((float)Interpolations.lerp((double)saveSnapshot.getScaleY(), (double)initialSnapshot.getScaleY(), percentageReset));
            bone.setScaleZ((float)Interpolations.lerp((double)saveSnapshot.getScaleZ(), (double)initialSnapshot.getScaleZ(), percentageReset));
            if (!(percentageReset >= 1.0)) continue;
            saveSnapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        }
        this.resetBoneTransformationMarkers();
        animatableManager.finishFirstTick();
    }

    private void resetBoneTransformationMarkers() {
        this.getRegisteredBones().forEach(CoreGeoBone::resetStateChanges);
    }

    private Map<String, BoneSnapshot> updateBoneSnapshots(Map<String, BoneSnapshot> snapshots) {
        for (CoreGeoBone bone : this.getRegisteredBones()) {
            if (snapshots.containsKey(bone.getName())) continue;
            snapshots.put(bone.getName(), BoneSnapshot.copy(bone.getInitialSnapshot()));
        }
        return snapshots;
    }

    public CoreGeoBone getBone(String boneName) {
        return this.bones.get(boneName);
    }

    public void registerGeoBone(CoreGeoBone bone) {
        bone.saveInitialSnapshot();
        this.bones.put(bone.getName(), bone);
        for (CoreGeoBone coreGeoBone : bone.getChildBones()) {
            this.registerGeoBone(coreGeoBone);
        }
    }

    public void setActiveModel(CoreBakedGeoModel model) {
        this.bones.clear();
        for (CoreGeoBone coreGeoBone : model.getBones()) {
            this.registerGeoBone(coreGeoBone);
        }
    }

    public Collection<CoreGeoBone> getRegisteredBones() {
        return this.bones.values();
    }

    public void preAnimationSetup(T animatable, double animTime) {
        this.model.applyMolangQueries(animatable, animTime);
    }

    public class QueuedAnimation {
        private Animation animation;
        private Animation.LoopType loopType;

        public QueuedAnimation(Animation animation, Animation.LoopType loopType) {
            this.animation = animation;
            this.loopType = loopType;
        }

        public Animation animation() {
            return this.animation;
        }

        public Animation.LoopType loopType() {
            return this.loopType;
        }
    }
}

