/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.core.keyframe;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.core.animation.EasingType;
import mod.azure.azurelib.core.math.IValue;

public class Keyframe<T extends IValue> {
    double length;
    T startValue;
    T endValue;
    EasingType easingType;
    List<T> easingArgs;

    public Keyframe(double length, T startValue, T endValue, EasingType easingType, List<T> easingArgs) {
        this.length = length;
        this.startValue = startValue;
        this.endValue = endValue;
        this.easingArgs = easingArgs;
        this.easingType = easingType;
    }

    public Keyframe(double length, T startValue, T endValue) {
        this(length, startValue, endValue, EasingType.LINEAR);
    }

    public Keyframe(double length, T startValue, T endValue, EasingType easingType) {
        this(length, startValue, endValue, easingType, (List<T>)new ObjectArrayList(0));
    }

    public int hashCode() {
        return Objects.hash(this.length, this.startValue, this.endValue, this.easingType, this.easingArgs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public double length() {
        return this.length;
    }

    public T startValue() {
        return this.startValue;
    }

    public T endValue() {
        return this.endValue;
    }

    public EasingType easingType() {
        return this.easingType;
    }

    public List<T> easingArgs() {
        return this.easingArgs;
    }
}

