/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import mod.azure.azurelib.loading.json.raw.Cube;
import mod.azure.azurelib.loading.json.raw.LocatorValue;
import mod.azure.azurelib.loading.json.raw.PolyMesh;
import mod.azure.azurelib.loading.json.raw.TextureMesh;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.util.JSONUtils;

public class Bone {
    private final double[] bindPoseRotation;
    private final Cube[] cubes;
    private final Boolean debug;
    private final Double inflate;
    private final Map<String, LocatorValue> locators;
    private final Boolean mirror;
    private final String name;
    private final Boolean neverRender;
    private final String parent;
    private final double[] pivot;
    private final PolyMesh polyMesh;
    private final Long renderGroupId;
    private final Boolean reset;
    private final double[] rotation;
    private final TextureMesh[] textureMeshes;

    public Bone(double[] bindPoseRotation, Cube[] cubes, Boolean debug, Double inflate, Map<String, LocatorValue> locators, Boolean mirror, String name, Boolean neverRender, String parent, double[] pivot, PolyMesh polyMesh, Long renderGroupId, Boolean reset, double[] rotation, TextureMesh[] textureMeshes) {
        this.bindPoseRotation = bindPoseRotation;
        this.cubes = cubes;
        this.debug = debug;
        this.inflate = inflate;
        this.locators = locators;
        this.mirror = mirror;
        this.name = name;
        this.neverRender = neverRender;
        this.parent = parent;
        this.pivot = pivot;
        this.polyMesh = polyMesh;
        this.renderGroupId = renderGroupId;
        this.reset = reset;
        this.rotation = rotation;
        this.textureMeshes = textureMeshes;
    }

    public double[] bindPoseRotation() {
        return this.bindPoseRotation;
    }

    public Cube[] cubes() {
        return this.cubes;
    }

    public Boolean debug() {
        return this.debug;
    }

    public Double inflate() {
        return this.inflate;
    }

    public Map<String, LocatorValue> locators() {
        return this.locators;
    }

    public Boolean mirror() {
        return this.mirror;
    }

    public String name() {
        return this.name;
    }

    public Boolean neverRender() {
        return this.neverRender;
    }

    public String parent() {
        return this.parent;
    }

    public double[] pivot() {
        return this.pivot;
    }

    public PolyMesh polyMesh() {
        return this.polyMesh;
    }

    public Long renderGroupId() {
        return this.renderGroupId;
    }

    public Boolean reset() {
        return this.reset;
    }

    public double[] rotation() {
        return this.rotation;
    }

    public TextureMesh[] textureMeshes() {
        return this.textureMeshes;
    }

    public static JsonDeserializer<Bone> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            double[] bindPoseRotation = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"bind_pose_rotation", null));
            Cube[] cubes = JsonUtil.jsonArrayToObjectArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"cubes", (JsonArray)new JsonArray()), context, Cube.class);
            Boolean debug = JsonUtil.getOptionalBoolean(obj, "debug");
            Double inflate = JsonUtil.getOptionalDouble(obj, "inflate");
            Map<String, LocatorValue> locators = obj.has("locators") ? JsonUtil.jsonObjToMap(JSONUtils.func_152754_s((JsonObject)obj, (String)"locators"), context, LocatorValue.class) : null;
            Boolean mirror = JsonUtil.getOptionalBoolean(obj, "mirror");
            String name = JSONUtils.func_151219_a((JsonObject)obj, (String)"name", null);
            Boolean neverRender = JsonUtil.getOptionalBoolean(obj, "neverRender");
            String parent = JSONUtils.func_151219_a((JsonObject)obj, (String)"parent", null);
            double[] pivot = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"pivot", (JsonArray)new JsonArray()));
            PolyMesh polyMesh = (PolyMesh)JSONUtils.func_188177_a((JsonObject)obj, (String)"poly_mesh", null, (JsonDeserializationContext)context, PolyMesh.class);
            Long renderGroupId = JsonUtil.getOptionalLong(obj, "render_group_id");
            Boolean reset = JsonUtil.getOptionalBoolean(obj, "reset");
            double[] rotation = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"rotation", null));
            TextureMesh[] textureMeshes = JsonUtil.jsonArrayToObjectArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"texture_meshes", (JsonArray)new JsonArray()), context, TextureMesh.class);
            return new Bone(bindPoseRotation, cubes, debug, inflate, locators, mirror, name, neverRender, parent, pivot, polyMesh, renderGroupId, reset, rotation, textureMeshes);
        };
    }
}

