/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.azure.azurelib.loading.json.raw.UVUnion;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.util.JSONUtils;

public class Cube {
    private final Double inflate;
    private final Boolean mirror;
    private final double[] origin;
    private final double[] pivot;
    private final double[] rotation;
    private final double[] size;
    private final UVUnion uv;

    public Cube(Double inflate, Boolean mirror, double[] origin, double[] pivot, double[] rotation, double[] size, UVUnion uv) {
        this.inflate = inflate;
        this.mirror = mirror;
        this.origin = origin;
        this.pivot = pivot;
        this.rotation = rotation;
        this.size = size;
        this.uv = uv;
    }

    public Double inflate() {
        return this.inflate;
    }

    public Boolean mirror() {
        return this.mirror;
    }

    public double[] origin() {
        return this.origin;
    }

    public double[] pivot() {
        return this.pivot;
    }

    public double[] rotation() {
        return this.rotation;
    }

    public double[] size() {
        return this.size;
    }

    public UVUnion uv() {
        return this.uv;
    }

    public static JsonDeserializer<Cube> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Double inflate = JsonUtil.getOptionalDouble(obj, "inflate");
            Boolean mirror = JsonUtil.getOptionalBoolean(obj, "mirror");
            double[] origin = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"origin", null));
            double[] pivot = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"pivot", null));
            double[] rotation = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"rotation", null));
            double[] size = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"size", null));
            UVUnion uvUnion = (UVUnion)JSONUtils.func_188177_a((JsonObject)obj, (String)"uv", null, (JsonDeserializationContext)context, UVUnion.class);
            return new Cube(inflate, mirror, origin, pivot, rotation, size, uvUnion);
        };
    }
}

