/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.MathHelper;

public class FaceUV {
    private final String materialInstance;
    private final double[] uv;
    private final double[] uvSize;
    private final Rotation uvRotation;

    public FaceUV(String materialInstance, double[] uv, double[] uvSize, Rotation uvRotation) {
        this.materialInstance = materialInstance;
        this.uv = uv;
        this.uvSize = uvSize;
        this.uvRotation = uvRotation;
    }

    public String getMaterialInstance() {
        return this.materialInstance;
    }

    public double[] getUv() {
        return this.uv;
    }

    public double[] getUvSize() {
        return this.uvSize;
    }

    public Rotation getUvRotation() {
        return this.uvRotation;
    }

    public static JsonDeserializer<FaceUV> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            String materialInstance = JSONUtils.func_151219_a((JsonObject)obj, (String)"material_instance", null);
            double[] uv = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"uv", null));
            double[] uvSize = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"uv_size", null));
            Rotation uvRotation = Rotation.fromValue(JSONUtils.func_151208_a((JsonObject)obj, (String)"uv_rotation", (int)0));
            return new FaceUV(materialInstance, uv, uvSize, uvRotation);
        };
    }

    public static enum Rotation {
        NONE,
        CLOCKWISE_90,
        CLOCKWISE_180,
        CLOCKWISE_270;


        public static Rotation fromValue(int value) throws JsonParseException {
            try {
                return Rotation.values()[value % 360 / 90];
            }
            catch (Exception e) {
                AzureLib.LOGGER.error("Invalid Face UV rotation: " + value);
                return Rotation.fromValue(MathHelper.func_76141_d((float)((float)Math.abs(value) / 90.0f)) * 90);
            }
        }

        public float[] rotateUvs(float u, float v, float uWidth, float vHeight) {
            switch (this) {
                case NONE: {
                    return new float[]{u, v, uWidth, v, uWidth, vHeight, u, vHeight};
                }
                case CLOCKWISE_90: {
                    return new float[]{uWidth, v, uWidth, vHeight, u, vHeight, u, v};
                }
                case CLOCKWISE_180: {
                    return new float[]{uWidth, vHeight, u, vHeight, u, v, uWidth, v};
                }
                case CLOCKWISE_270: {
                    return new float[]{u, vHeight, u, v, uWidth, v, uWidth, vHeight};
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }
    }
}

