/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.util.JSONUtils;

public class LocatorClass {
    private final Boolean ignoreInheritedScale;
    private final double[] offset;
    private final double[] rotation;

    public LocatorClass(Boolean ignoreInheritedScale, double[] offset, double[] rotation) {
        this.ignoreInheritedScale = ignoreInheritedScale;
        this.offset = offset;
        this.rotation = rotation;
    }

    public Boolean ignoreInheritedScale() {
        return this.ignoreInheritedScale;
    }

    public double[] offset() {
        return this.offset;
    }

    public double[] rotation() {
        return this.rotation;
    }

    public static JsonDeserializer<LocatorClass> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Boolean ignoreInheritedScale = JsonUtil.getOptionalBoolean(obj, "ignore_inherited_scale");
            double[] offset = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"offset", null));
            double[] rotation = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"rotation", null));
            return new LocatorClass(ignoreInheritedScale, offset, rotation);
        };
    }
}

