/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.azure.azurelib.loading.json.FormatVersion;
import mod.azure.azurelib.loading.json.raw.MinecraftGeometry;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.util.JSONUtils;

public class Model {
    private final FormatVersion formatVersion;
    private final MinecraftGeometry[] minecraftGeometry;

    public Model(FormatVersion formatVersion, MinecraftGeometry[] minecraftGeometry) {
        this.formatVersion = formatVersion;
        this.minecraftGeometry = minecraftGeometry;
    }

    public FormatVersion formatVersion() {
        return this.formatVersion;
    }

    public MinecraftGeometry[] minecraftGeometry() {
        return this.minecraftGeometry;
    }

    public static JsonDeserializer<Model> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            FormatVersion formatVersion = (FormatVersion)((Object)((Object)context.deserialize(obj.get("format_version"), FormatVersion.class)));
            MinecraftGeometry[] minecraftGeometry = JsonUtil.jsonArrayToObjectArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"minecraft:geometry", (JsonArray)new JsonArray()), context, MinecraftGeometry.class);
            return new Model(formatVersion, minecraftGeometry);
        };
    }
}

