/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.azure.azurelib.loading.json.raw.PolysUnion;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.util.JSONUtils;

public class PolyMesh {
    private final Boolean normalizedUVs;
    private final double[] normals;
    private final PolysUnion polysUnion;
    private final double[] positions;
    private final double[] uvs;

    public PolyMesh(Boolean normalizedUVs, double[] normals, PolysUnion polysUnion, double[] positions, double[] uvs) {
        this.normalizedUVs = normalizedUVs;
        this.normals = normals;
        this.polysUnion = polysUnion;
        this.positions = positions;
        this.uvs = uvs;
    }

    public Boolean normalizedUVs() {
        return this.normalizedUVs;
    }

    public double[] normals() {
        return this.normals;
    }

    public PolysUnion polysUnion() {
        return this.polysUnion;
    }

    public double[] positions() {
        return this.positions;
    }

    public double[] uvs() {
        return this.uvs;
    }

    public static JsonDeserializer<PolyMesh> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Boolean normalizedUVs = JsonUtil.getOptionalBoolean(obj, "normalized_uvs");
            double[] normals = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"normals", null));
            PolysUnion polysUnion = (PolysUnion)JSONUtils.func_188177_a((JsonObject)obj, (String)"polys", null, (JsonDeserializationContext)context, PolysUnion.class);
            double[] positions = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"positions", null));
            double[] uvs = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"uvs", null));
            return new PolyMesh(normalizedUVs, normals, polysUnion, positions, uvs);
        };
    }
}

