/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import mod.azure.azurelib.util.JsonUtil;

public class PolysUnion {
    private final double[][][] union;
    private final Type type;

    public PolysUnion(double[][][] union, Type type) {
        this.union = union;
        this.type = type;
    }

    public double[][][] union() {
        return this.union;
    }

    public Type type() {
        return this.type;
    }

    public static JsonDeserializer<PolysUnion> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return new PolysUnion(new double[0][0][0], (Type)((Object)((Object)context.deserialize((JsonElement)json.getAsJsonPrimitive(), Type.class))));
            }
            if (json.isJsonArray()) {
                JsonArray array = json.getAsJsonArray();
                double[][][] matrix = PolysUnion.makeSizedMatrix(array);
                for (int x = 0; x < array.size(); ++x) {
                    JsonArray xArray = array.get(x).getAsJsonArray();
                    for (int y = 0; y < xArray.size(); ++y) {
                        JsonArray yArray = xArray.get(y).getAsJsonArray();
                        matrix[x][y] = JsonUtil.jsonArrayToDoubleArray(yArray);
                    }
                }
                return new PolysUnion(matrix, null);
            }
            throw new JsonParseException("Invalid format for PolysUnion, must be either string or array");
        };
    }

    private static double[][][] makeSizedMatrix(JsonArray array) {
        JsonArray subArray = array.size() > 0 ? array.get(0).getAsJsonArray() : null;
        JsonArray subSubArray = subArray != null && subArray.size() > 0 ? subArray.get(0).getAsJsonArray() : null;
        int ySize = subArray != null ? subArray.size() : 0;
        int zSize = subSubArray != null ? subSubArray.size() : 0;
        return new double[array.size()][ySize][zSize];
    }

    public static enum Type {
        QUAD,
        TRI;

    }
}

