/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.azure.azurelib.util.JsonUtil;
import net.minecraft.util.JSONUtils;

public class TextureMesh {
    private final double[] localPivot;
    private final double[] position;
    private final double[] rotation;
    private final double[] scale;
    private final String texture;

    public TextureMesh(double[] localPivot, double[] position, double[] rotation, double[] scale, String texture) {
        this.localPivot = localPivot;
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
        this.texture = texture;
    }

    public double[] localPivot() {
        return this.localPivot;
    }

    public double[] position() {
        return this.position;
    }

    public double[] rotation() {
        return this.rotation;
    }

    public double[] scale() {
        return this.scale;
    }

    public String texture() {
        return this.texture;
    }

    public static JsonDeserializer<TextureMesh> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            double[] pivot = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"local_pivot", null));
            double[] position = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"position", null));
            double[] rotation = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"rotation", null));
            double[] scale = JsonUtil.jsonArrayToDoubleArray(JSONUtils.func_151213_a((JsonObject)obj, (String)"scale", null));
            String texture = JSONUtils.func_151219_a((JsonObject)obj, (String)"texture", null);
            return new TextureMesh(pivot, position, rotation, scale, texture);
        };
    }
}

