/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.loading.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.cache.object.GeoVertex;
import mod.azure.azurelib.loading.json.raw.Bone;
import mod.azure.azurelib.loading.json.raw.Cube;
import mod.azure.azurelib.loading.json.raw.FaceUV;
import mod.azure.azurelib.loading.json.raw.ModelProperties;
import mod.azure.azurelib.loading.json.raw.UVUnion;
import mod.azure.azurelib.loading.object.BoneStructure;
import mod.azure.azurelib.loading.object.GeometryTree;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.Vector3d;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;

@Deprecated
public interface BakedModelFactory {
    public static final Map<String, BakedModelFactory> FACTORIES = new Object2ObjectOpenHashMap(1);
    public static final BakedModelFactory DEFAULT_FACTORY = new Builtin();

    public BakedGeoModel constructGeoModel(GeometryTree var1);

    public GeoBone constructBone(BoneStructure var1, ModelProperties var2, @Nullable GeoBone var3);

    public GeoCube constructCube(Cube var1, ModelProperties var2, GeoBone var3);

    default public GeoQuad[] buildQuads(UVUnion uvUnion, VertexSet vertices, Cube cube, float textureWidth, float textureHeight, boolean mirror) {
        GeoQuad[] quads = new GeoQuad[]{this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.WEST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.EAST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.NORTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.SOUTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.UP), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, Direction.DOWN)};
        return quads;
    }

    default public GeoQuad buildQuad(VertexSet vertices, Cube cube, UVUnion uvUnion, float textureWidth, float textureHeight, boolean mirror, Direction direction) {
        if (!uvUnion.isBoxUV()) {
            FaceUV faceUV = uvUnion.faceUV().fromDirection(direction);
            if (faceUV == null) {
                return null;
            }
            return GeoQuad.build(vertices.verticesForQuad(direction, false, mirror || cube.mirror() == Boolean.TRUE), faceUV.getUv(), faceUV.getUvSize(), faceUV.getUvRotation(), textureWidth, textureHeight, mirror, direction);
        }
        double[] uv = cube.uv().boxUVCoords();
        double[] uvSize = cube.size();
        Vector3d uvSizeVec = new Vector3d(Math.floor(uvSize[0]), Math.floor(uvSize[1]), Math.floor(uvSize[2]));
        double[][] uvData = new double[][]{{0.0}, {0.0}};
        switch (direction) {
            case WEST: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c + uvSizeVec.field_181059_a, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181061_c, uvSizeVec.field_181060_b}};
                break;
            }
            case EAST: {
                uvData = new double[][]{{uv[0], uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181061_c, uvSizeVec.field_181060_b}};
                break;
            }
            case NORTH: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181059_a, uvSizeVec.field_181060_b}};
                break;
            }
            case SOUTH: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c + uvSizeVec.field_181059_a + uvSizeVec.field_181061_c, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181059_a, uvSizeVec.field_181060_b}};
                break;
            }
            case UP: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c, uv[1]}, {uvSizeVec.field_181059_a, uvSizeVec.field_181061_c}};
                break;
            }
            case DOWN: {
                uvData = new double[][]{{uv[0] + uvSizeVec.field_181061_c + uvSizeVec.field_181059_a, uv[1] + uvSizeVec.field_181061_c}, {uvSizeVec.field_181059_a, -uvSizeVec.field_181061_c}};
            }
        }
        return GeoQuad.build(vertices.verticesForQuad(direction, true, mirror || cube.mirror() == Boolean.TRUE), uvData[0], uvData[1], FaceUV.Rotation.NONE, textureWidth, textureHeight, mirror, direction);
    }

    public static BakedModelFactory getForNamespace(String namespace) {
        return FACTORIES.getOrDefault(namespace, DEFAULT_FACTORY);
    }

    public static void register(String namespace, BakedModelFactory factory) {
        FACTORIES.put(namespace, factory);
    }

    public static class VertexSet {
        protected final GeoVertex bottomLeftBack;
        protected final GeoVertex bottomRightBack;
        protected final GeoVertex topLeftBack;
        protected final GeoVertex topRightBack;
        protected final GeoVertex topLeftFront;
        protected final GeoVertex topRightFront;
        protected final GeoVertex bottomLeftFront;
        protected final GeoVertex bottomRightFront;

        public VertexSet(GeoVertex bottomLeftBack, GeoVertex bottomRightBack, GeoVertex topLeftBack, GeoVertex topRightBack, GeoVertex topLeftFront, GeoVertex topRightFront, GeoVertex bottomLeftFront, GeoVertex bottomRightFront) {
            this.topRightFront = topRightFront;
            this.bottomLeftBack = bottomLeftBack;
            this.bottomRightBack = bottomRightBack;
            this.topLeftBack = topLeftBack;
            this.topRightBack = topRightBack;
            this.topLeftFront = topLeftFront;
            this.bottomLeftFront = bottomLeftFront;
            this.bottomRightFront = bottomRightFront;
        }

        public VertexSet(Vec3d origin, Vec3d vertexSize, double inflation) {
            this(new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b - inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b - inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation), new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a - inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b + vertexSize.field_72448_b + inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b - inflation, origin.field_72449_c - inflation), new GeoVertex(origin.field_72450_a + vertexSize.field_72450_a + inflation, origin.field_72448_b - inflation, origin.field_72449_c + vertexSize.field_72449_c + inflation));
        }

        public GeoVertex[] quadWest() {
            return new GeoVertex[]{this.topRightBack, this.topLeftBack, this.bottomLeftBack, this.bottomRightBack};
        }

        public GeoVertex[] quadEast() {
            return new GeoVertex[]{this.topLeftFront, this.topRightFront, this.bottomRightFront, this.bottomLeftFront};
        }

        public GeoVertex[] quadNorth() {
            return new GeoVertex[]{this.topLeftBack, this.topLeftFront, this.bottomLeftFront, this.bottomLeftBack};
        }

        public GeoVertex[] quadSouth() {
            return new GeoVertex[]{this.topRightFront, this.topRightBack, this.bottomRightBack, this.bottomRightFront};
        }

        public GeoVertex[] quadUp() {
            return new GeoVertex[]{this.topRightBack, this.topRightFront, this.topLeftFront, this.topLeftBack};
        }

        public GeoVertex[] quadDown() {
            return new GeoVertex[]{this.bottomLeftBack, this.bottomLeftFront, this.bottomRightFront, this.bottomRightBack};
        }

        public GeoVertex[] verticesForQuad(Direction direction, boolean boxUv, boolean mirror) {
            switch (direction) {
                case WEST: {
                    return mirror ? this.quadEast() : this.quadWest();
                }
                case EAST: {
                    return mirror ? this.quadWest() : this.quadEast();
                }
                case NORTH: {
                    return this.quadNorth();
                }
                case SOUTH: {
                    return this.quadSouth();
                }
                case UP: {
                    return mirror && !boxUv ? this.quadDown() : this.quadUp();
                }
                case DOWN: {
                    return mirror && !boxUv ? this.quadUp() : this.quadDown();
                }
            }
            return this.quadUp();
        }

        public GeoVertex bottomLeftBack() {
            return this.bottomLeftBack;
        }

        public GeoVertex bottomRightBack() {
            return this.bottomRightBack;
        }

        public GeoVertex topLeftBack() {
            return this.topLeftBack;
        }

        public GeoVertex topRightBack() {
            return this.topRightBack;
        }

        public GeoVertex topLeftFront() {
            return this.topLeftFront;
        }

        public GeoVertex topRightFront() {
            return this.topRightFront;
        }

        public GeoVertex bottomLeftFront() {
            return this.bottomLeftFront;
        }

        public GeoVertex bottomRightFront() {
            return this.bottomRightFront;
        }
    }

    public static final class Builtin
    implements BakedModelFactory {
        @Override
        public BakedGeoModel constructGeoModel(GeometryTree geometryTree) {
            ObjectArrayList bones = new ObjectArrayList();
            for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
                bones.add(this.constructBone(boneStructure, geometryTree.properties(), null));
            }
            return new BakedGeoModel((List<GeoBone>)bones, geometryTree.properties());
        }

        @Override
        public GeoBone constructBone(BoneStructure boneStructure, ModelProperties properties, GeoBone parent) {
            Bone bone = boneStructure.self();
            GeoBone newBone = new GeoBone(parent, bone.name(), bone.mirror(), bone.inflate(), bone.neverRender(), bone.reset());
            Vec3d rotation = RenderUtils.arrayToVec(bone.rotation());
            Vec3d pivot = RenderUtils.arrayToVec(bone.pivot());
            newBone.updateRotation((float)Math.toRadians(-rotation.field_72450_a), (float)Math.toRadians(-rotation.field_72448_b), (float)Math.toRadians(rotation.field_72449_c));
            newBone.updatePivot((float)(-pivot.field_72450_a), (float)pivot.field_72448_b, (float)pivot.field_72449_c);
            for (Cube cube : bone.cubes()) {
                newBone.getCubes().add(this.constructCube(cube, properties, newBone));
            }
            for (BoneStructure child : boneStructure.children().values()) {
                newBone.getChildBones().add(this.constructBone(child, properties, newBone));
            }
            return newBone;
        }

        @Override
        public GeoCube constructCube(Cube cube, ModelProperties properties, GeoBone bone) {
            boolean mirror;
            boolean bl = mirror = cube.mirror() == Boolean.TRUE;
            double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
            Vec3d size = RenderUtils.arrayToVec(cube.size());
            Vec3d origin = RenderUtils.arrayToVec(cube.origin());
            Vec3d rotation = RenderUtils.arrayToVec(cube.rotation());
            Vec3d pivot = RenderUtils.arrayToVec(cube.pivot());
            origin = new Vec3d(-(origin.field_72450_a + size.field_72450_a) / 16.0, origin.field_72448_b / 16.0, origin.field_72449_c / 16.0);
            Vec3d vertexSize = size.func_216372_d(0.0625, 0.0625, 0.0625);
            pivot = pivot.func_216372_d(-1.0, 1.0, 1.0);
            rotation = new Vec3d(Math.toRadians(-rotation.field_72450_a), Math.toRadians(-rotation.field_72448_b), Math.toRadians(rotation.field_72449_c));
            GeoQuad[] quads = this.buildQuads(cube.uv(), new VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
            return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
        }
    }
}

