/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import mod.azure.azurelib.AzureLibException;
import mod.azure.azurelib.cache.AzureLibCache;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreGeoModel;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationProcessor;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.MolangQueries;
import mod.azure.azurelib.core.object.DataTicket;
import mod.azure.azurelib.loading.object.BakedAnimations;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

@Deprecated
public abstract class GeoModel<T extends GeoAnimatable>
implements CoreGeoModel<T> {
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    private BakedGeoModel currentModel = null;
    private double animTime;
    private double lastGameTickTime;
    private long lastRenderedInstance = -1L;

    public abstract ResourceLocation getModelResource(T var1);

    public abstract ResourceLocation getTextureResource(T var1);

    public abstract ResourceLocation getAnimationResource(T var1);

    public boolean crashIfBoneMissing() {
        return false;
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture) {
        return RenderType.func_228640_c_((ResourceLocation)texture);
    }

    @Override
    public final BakedGeoModel getBakedGeoModel(String location) {
        return this.getBakedModel(new ResourceLocation(location));
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        BakedGeoModel model = AzureLibCache.getBakedModels().get(location);
        if (model == null) {
            throw new AzureLibException(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.processor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    @Override
    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable((GeoBone)this.getAnimationProcessor().getBone(name));
    }

    @Override
    public Animation getAnimation(T animatable, String name) {
        ResourceLocation location = this.getAnimationResource(animatable);
        BakedAnimations bakedAnimations = AzureLibCache.getBakedAnimations().get(location);
        if (bakedAnimations == null) {
            throw new AzureLibException(location, "Unable to find animation.");
        }
        return bakedAnimations.getAnimation(name);
    }

    @Override
    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(T animatable, long instanceId, BiConsumer<DataTicket<T>, T> dataConsumer) {
    }

    @Override
    public void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        boolean isReRender;
        Minecraft mc = Minecraft.func_71410_x();
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            currentTick = animatable instanceof LivingEntity ? (double)((LivingEntity)animatable).field_70173_aa : RenderUtils.getCurrentTick();
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)mc.func_184121_ak());
        }
        double currentFrameTime = currentTick - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        if (!(isReRender || mc.func_147113_T() && !animatable.shouldPlayAnimsWhileGamePaused())) {
            if (animatable instanceof LivingEntity) {
                animatableManager.updatedAt(currentFrameTime);
            } else {
                animatableManager.updatedAt(currentFrameTime);
            }
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        animationState.animationTick = this.animTime;
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        processor.preAnimationSetup(animationState.getAnimatable(), this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, this, animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations(animatable, instanceId, animationState);
    }

    @Override
    public void applyMolangQueries(T animatable, double animTime) {
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft mc = Minecraft.func_71410_x();
        parser.setMemoizedValue(MolangQueries.LIFE_TIME, () -> animTime / 20.0);
        parser.setMemoizedValue(MolangQueries.ACTOR_COUNT, () -> ((ClientWorld)mc.field_71441_e).func_217425_f());
        parser.setMemoizedValue(MolangQueries.TIME_OF_DAY, () -> (float)mc.field_71441_e.func_72820_D() / 24000.0f);
        parser.setMemoizedValue(MolangQueries.MOON_PHASE, () -> ((ClientWorld)mc.field_71441_e).func_72853_d());
        if (animatable instanceof Entity) {
            parser.setMemoizedValue(MolangQueries.DISTANCE_FROM_CAMERA, () -> mc.field_71460_t.func_215316_n().func_216785_c().func_72438_d(((Entity)animatable).func_213303_ch()));
            parser.setMemoizedValue(MolangQueries.IS_ON_GROUND, () -> RenderUtils.booleanToFloat(((Entity)animatable).field_70122_E));
            parser.setMemoizedValue(MolangQueries.IS_IN_WATER, () -> RenderUtils.booleanToFloat(((Entity)animatable).func_70090_H()));
            parser.setMemoizedValue(MolangQueries.IS_IN_WATER_OR_RAIN, () -> RenderUtils.booleanToFloat(((Entity)animatable).func_203008_ap()));
            parser.setMemoizedValue(MolangQueries.IS_ON_FIRE, () -> RenderUtils.booleanToFloat(((Entity)animatable).func_70027_ad()));
            if (animatable instanceof LivingEntity) {
                parser.setMemoizedValue(MolangQueries.HEALTH, () -> ((LivingEntity)((LivingEntity)animatable)).func_110143_aJ());
                parser.setMemoizedValue(MolangQueries.MAX_HEALTH, () -> ((LivingEntity)((LivingEntity)animatable)).func_110138_aP());
                parser.setMemoizedValue(MolangQueries.GROUND_SPEED, () -> {
                    Vec3d velocity = ((LivingEntity)animatable).func_213322_ci();
                    return Math.sqrt((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c));
                });
                parser.setMemoizedValue(MolangQueries.YAW_SPEED, () -> ((LivingEntity)animatable).field_70177_z - ((LivingEntity)animatable).field_70126_B);
            }
        }
    }
}

