/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class AzBlockEntityDispatchCommandPacket
extends AbstractPacket {
    private final BlockPos blockPos;
    private final AzCommand dispatchCommand;

    public AzBlockEntityDispatchCommandPacket(BlockPos blockPos, AzCommand dispatchCommand) {
        this.blockPos = blockPos;
        this.dispatchCommand = dispatchCommand;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.blockPos);
        AzCommand.ENCODER.accept(buf, this.dispatchCommand);
    }

    public static AzBlockEntityDispatchCommandPacket receive(PacketBuffer buf) {
        BlockPos blockPos = buf.func_179259_c();
        AzCommand dispatchCommand = AzCommand.DECODER.apply(buf);
        return new AzBlockEntityDispatchCommandPacket(blockPos, dispatchCommand);
    }

    @Override
    public void handle() {
        TileEntity blockEntity = ClientUtils.getLevel().func_175625_s(this.blockPos);
        if (blockEntity == null) {
            return;
        }
        AzAnimator<TileEntity> animator = AzAnimatorAccessor.getOrNull(blockEntity);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }
}

