/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.util.ClientUtils;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;

public class AzEntityDispatchCommandPacket
extends AbstractPacket {
    private final int entityId;
    private final AzCommand dispatchCommand;

    public AzEntityDispatchCommandPacket(int entityId, AzCommand dispatchCommand) {
        this.entityId = entityId;
        this.dispatchCommand = dispatchCommand;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        AzCommand.ENCODER.accept(buf, this.dispatchCommand);
    }

    public static AzEntityDispatchCommandPacket receive(PacketBuffer buf) {
        int entityId = buf.readInt();
        AzCommand dispatchCommand = AzCommand.DECODER.apply(buf);
        return new AzEntityDispatchCommandPacket(entityId, dispatchCommand);
    }

    @Override
    public void handle() {
        Entity entity = ClientUtils.getLevel().func_73045_a(this.entityId);
        if (entity == null) {
            return;
        }
        AzAnimator<Entity> animator = AzAnimatorAccessor.getOrNull(entity);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }
}

