/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.object.DataTicket;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayersContainer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@Deprecated
public class GeoArmorRenderer<T extends Item>
extends BipedModel
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected T animatable;
    protected BipedModel<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    protected BakedGeoModel lastModel = null;
    protected GeoBone head = null;
    protected GeoBone body = null;
    protected GeoBone rightArm = null;
    protected GeoBone leftArm = null;
    protected GeoBone rightLeg = null;
    protected GeoBone leftLeg = null;
    protected GeoBone rightBoot = null;
    protected GeoBone leftBoot = null;
    protected Entity currentEntity = null;
    protected ItemStack currentStack = null;
    protected EquipmentSlotType currentSlot = null;

    public GeoArmorRenderer(GeoModel<T> model) {
        super(1.0f);
        this.model = model;
        this.field_217114_e = false;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public Entity getCurrentEntity() {
        return this.currentEntity;
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public EquipmentSlotType getCurrentSlot() {
        return this.currentSlot;
    }

    @Override
    public long getInstanceId(T animatable) {
        return GeoItem.getId(this.currentStack) + (long)this.currentEntity.func_145782_y();
    }

    @Override
    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable IRenderTypeBuffer bufferSource, float partialTick) {
        return RenderType.func_228640_c_((ResourceLocation)texture);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoArmorRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoArmorRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoArmorRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Nullable
    public GeoBone getHeadBone() {
        return this.model.getBone("armorHead").orElse(null);
    }

    @Nullable
    public GeoBone getBodyBone() {
        return this.model.getBone("armorBody").orElse(null);
    }

    @Nullable
    public GeoBone getRightArmBone() {
        return this.model.getBone("armorRightArm").orElse(null);
    }

    @Nullable
    public GeoBone getLeftArmBone() {
        return this.model.getBone("armorLeftArm").orElse(null);
    }

    @Nullable
    public GeoBone getRightLegBone() {
        return this.model.getBone("armorRightLeg").orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegBone() {
        return this.model.getBone("armorLeftLeg").orElse(null);
    }

    @Nullable
    public GeoBone getRightBootBone() {
        return this.model.getBone("armorRightBoot").orElse(null);
    }

    @Nullable
    public GeoBone getLeftBootBone() {
        return this.model.getBone("armorLeftBoot").orElse(null);
    }

    @Override
    public void preRender(MatrixStack poseStack, T animatable, BakedGeoModel model, @Nullable IRenderTypeBuffer bufferSource, @Nullable IVertexBuilder buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        this.applyBaseModel(this.baseModel);
        this.grabRelevantBones(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)this.animatable)));
        this.applyBaseTransformations(this.baseModel);
        this.scaleModelForBaby(poseStack, animatable, partialTick, isReRender);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!(this.currentEntity instanceof GeoAnimatable)) {
            this.applyBoneVisibilityBySlot(this.currentSlot);
        }
    }

    public void func_225598_a_(MatrixStack poseStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl bufferSource = mc.field_71438_f.field_228415_m_.func_228487_b_();
        if (mc.field_71438_f.func_174985_d()) {
            bufferSource = mc.field_71438_f.field_228415_m_.func_228490_d_();
        }
        float partialTick = mc.func_184121_ak();
        RenderType renderType = this.getRenderType(this.animatable, this.getTextureLocation((GeoAnimatable)this.animatable), (IRenderTypeBuffer)bufferSource, partialTick);
        buffer = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferSource, (RenderType)renderType, (boolean)false, (boolean)this.currentStack.func_77962_s());
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, (IRenderTypeBuffer)bufferSource, null, buffer, 0.0f, partialTick, packedLight);
    }

    @Override
    public void actuallyRender(MatrixStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, 1.5, 0.0);
        poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        if (!isReRender) {
            AnimationState<GeoAnimatable> animationState = new AnimationState<GeoAnimatable>((GeoAnimatable)animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoItem)animatable).getTick(this.currentEntity));
            animationState.setData(DataTickets.ITEMSTACK, this.currentStack);
            animationState.setData(DataTickets.ENTITY, this.currentEntity);
            animationState.setData(DataTickets.EQUIPMENT_SLOT, this.currentSlot);
            this.model.addAdditionalStateData((Item)((GeoAnimatable)animatable), instanceId, (BiConsumer<DataTicket<Item>, Item>)((BiConsumer<DataTicket, Item>)(x$0, x$1) -> animationState.setData(x$0, x$1)));
            this.model.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        GeoRenderer.super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.func_227865_b_();
    }

    @Override
    public void renderRecursively(MatrixStack poseStack, T animatable, GeoBone bone, RenderType renderType, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel == bakedModel) {
            return;
        }
        this.lastModel = bakedModel;
        this.head = this.getHeadBone();
        this.body = this.getBodyBone();
        this.rightArm = this.getRightArmBone();
        this.leftArm = this.getLeftArmBone();
        this.rightLeg = this.getRightLegBone();
        this.leftLeg = this.getLeftLegBone();
        this.rightBoot = this.getRightBootBone();
        this.leftBoot = this.getLeftBootBone();
    }

    public void prepForRender(@Nullable Entity entity, ItemStack stack, @Nullable EquipmentSlotType slot, @Nullable BipedModel<?> baseModel) {
        if (entity == null || slot == null || baseModel == null) {
            return;
        }
        this.baseModel = baseModel;
        this.currentEntity = entity;
        this.currentStack = stack;
        this.animatable = stack.func_77973_b();
        this.currentSlot = slot;
    }

    protected void applyBaseModel(BipedModel<?> baseModel) {
        this.field_217114_e = baseModel.field_217114_e;
        this.field_228270_o_ = baseModel.field_228270_o_;
        this.field_217113_d = baseModel.field_217113_d;
        this.field_187076_m = baseModel.field_187076_m;
        this.field_187075_l = baseModel.field_187075_l;
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlotType currentSlot) {
        this.func_178719_a(false);
        switch (currentSlot) {
            case HEAD: {
                this.setBoneVisible(this.head, true);
                return;
            }
            case CHEST: {
                this.setBoneVisible(this.body, true);
                this.setBoneVisible(this.rightArm, true);
                this.setBoneVisible(this.leftArm, true);
                return;
            }
            case LEGS: {
                this.setBoneVisible(this.rightLeg, true);
                this.setBoneVisible(this.leftLeg, true);
                return;
            }
            case FEET: {
                this.setBoneVisible(this.rightBoot, true);
                this.setBoneVisible(this.leftBoot, true);
                return;
            }
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlotType currentSlot, ModelRenderer currentPart, BipedModel<?> model) {
        this.func_178719_a(false);
        currentPart.field_78806_j = true;
        GeoBone bone = null;
        if (currentPart == model.field_178720_f || currentPart == model.field_78116_c) {
            bone = this.head;
        } else if (currentPart == model.field_78115_e) {
            bone = this.body;
        } else if (currentPart == model.field_178724_i) {
            bone = this.leftArm;
        } else if (currentPart == model.field_178723_h) {
            bone = this.rightArm;
        } else if (currentPart == model.field_178722_k) {
            bone = currentSlot == EquipmentSlotType.FEET ? this.leftBoot : this.leftLeg;
        } else if (currentPart == model.field_178721_j) {
            GeoBone geoBone = bone = currentSlot == EquipmentSlotType.FEET ? this.rightBoot : this.rightLeg;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(BipedModel<?> baseModel) {
        if (this.head != null) {
            ModelRenderer headPart = baseModel.field_78116_c;
            RenderUtils.matchModelPartRot(headPart, this.head);
            this.head.updatePosition(headPart.field_78800_c, -headPart.field_78797_d, headPart.field_78798_e);
        }
        if (this.body != null) {
            ModelRenderer bodyPart = baseModel.field_78115_e;
            RenderUtils.matchModelPartRot(bodyPart, this.body);
            this.body.updatePosition(bodyPart.field_78800_c, -bodyPart.field_78797_d, bodyPart.field_78798_e);
        }
        if (this.rightArm != null) {
            ModelRenderer rightArmPart = baseModel.field_178723_h;
            RenderUtils.matchModelPartRot(rightArmPart, this.rightArm);
            this.rightArm.updatePosition(rightArmPart.field_78800_c + 5.0f, 2.0f - rightArmPart.field_78797_d, rightArmPart.field_78798_e);
        }
        if (this.leftArm != null) {
            ModelRenderer leftArmPart = baseModel.field_178724_i;
            RenderUtils.matchModelPartRot(leftArmPart, this.leftArm);
            this.leftArm.updatePosition(leftArmPart.field_78800_c - 5.0f, 2.0f - leftArmPart.field_78797_d, leftArmPart.field_78798_e);
        }
        if (this.rightLeg != null) {
            ModelRenderer rightLegPart = baseModel.field_178721_j;
            RenderUtils.matchModelPartRot(rightLegPart, this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.field_78800_c + 2.0f, 12.0f - rightLegPart.field_78797_d, rightLegPart.field_78798_e);
            if (this.rightBoot != null) {
                RenderUtils.matchModelPartRot(rightLegPart, this.rightBoot);
                this.rightBoot.updatePosition(rightLegPart.field_78800_c + 2.0f, 12.0f - rightLegPart.field_78797_d, rightLegPart.field_78798_e);
            }
        }
        if (this.leftLeg != null) {
            ModelRenderer leftLegPart = baseModel.field_178722_k;
            RenderUtils.matchModelPartRot(leftLegPart, this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.field_78800_c - 2.0f, 12.0f - leftLegPart.field_78797_d, leftLegPart.field_78798_e);
            if (this.leftBoot != null) {
                RenderUtils.matchModelPartRot(leftLegPart, this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.field_78800_c - 2.0f, 12.0f - leftLegPart.field_78797_d, leftLegPart.field_78798_e);
            }
        }
    }

    public void func_178719_a(boolean pVisible) {
        super.func_178719_a(pVisible);
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void scaleModelForBaby(MatrixStack poseStack, T animatable, float partialTick, boolean isReRender) {
        if (!this.field_217114_e || isReRender) {
            return;
        }
        if (this.currentSlot == EquipmentSlotType.HEAD) {
            if (this.baseModel.field_228221_a_) {
                float headScale = 1.5f / this.baseModel.field_228224_g_;
                poseStack.func_227862_a_(headScale, headScale, headScale);
            }
            poseStack.func_227861_a_(0.0, (double)(this.baseModel.field_228222_b_ / 16.0f), (double)(this.baseModel.field_228223_f_ / 16.0f));
        } else {
            float bodyScale = 1.0f / this.baseModel.field_228225_h_;
            poseStack.func_227862_a_(bodyScale, bodyScale, bodyScale);
            poseStack.func_227861_a_(0.0, (double)(this.baseModel.field_228226_i_ / 16.0f), 0.0);
        }
    }

    protected void setBoneVisible(@Nullable GeoBone bone, boolean visible) {
        if (bone == null) {
            return;
        }
        bone.setHidden(!visible);
    }
}

