/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.object.DataTicket;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.model.data.EntityModelData;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.LightType;

@Deprecated
public class GeoEntityRenderer<T extends Entity>
extends EntityRenderer<T>
implements GeoRenderer<T> {
    protected final List<GeoRenderLayer<T>> renderLayers = new ObjectArrayList();
    protected final GeoModel<T> model;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoEntityRenderer(EntityRendererManager renderManager, GeoModel<T> model) {
        super(renderManager);
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(T animatable) {
        return animatable.func_145782_y();
    }

    @Override
    public ResourceLocation getTextureLocation(T animatable) {
        return GeoRenderer.super.getTextureLocation((GeoAnimatable)animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers;
    }

    public GeoEntityRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.add(renderLayer);
        return this;
    }

    public GeoEntityRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoEntityRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(MatrixStack poseStack, T animatable, BakedGeoModel model, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void func_225623_a_(T entity, float entityYaw, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, int packedLight) {
        this.animatable = entity;
        this.defaultRender(poseStack, (GeoAnimatable)entity, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    @Override
    public void actuallyRender(MatrixStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Direction bedDirection;
        poseStack.func_227860_a_();
        LivingEntity livingEntity = animatable instanceof LivingEntity ? (LivingEntity)animatable : null;
        boolean shouldSit = animatable.func_184218_aH() && animatable.func_184187_bx() != null;
        float lerpBodyRot = livingEntity == null ? 0.0f : MathHelper.func_226167_j_((float)partialTick, (float)livingEntity.field_70760_ar, (float)livingEntity.field_70761_aq);
        float lerpHeadRot = livingEntity == null ? 0.0f : MathHelper.func_226167_j_((float)partialTick, (float)livingEntity.field_70758_at, (float)livingEntity.field_70759_as);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && animatable.func_184187_bx() instanceof LivingEntity) {
            lerpBodyRot = MathHelper.func_226167_j_((float)partialTick, (float)((LivingEntity)animatable.func_184187_bx()).field_70760_ar, (float)((LivingEntity)animatable.func_184187_bx()).field_70761_aq);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.func_213283_Z() == Pose.SLEEPING && livingEntity != null && (bedDirection = livingEntity.func_213376_dz()) != null) {
            float eyePosOffset = livingEntity.func_213307_e(Pose.STANDING) - 0.1f;
            poseStack.func_227861_a_((double)((float)(-bedDirection.func_82601_c()) * eyePosOffset), 0.0, (double)((float)(-bedDirection.func_82599_e()) * eyePosOffset));
        }
        float nativeScale = livingEntity != null ? livingEntity.func_213355_cm() : 1.0f;
        float ageInTicks = (float)((Entity)animatable).field_70173_aa + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        poseStack.func_227862_a_(nativeScale, nativeScale, nativeScale);
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
        if (!shouldSit && animatable.func_70089_S() && livingEntity != null) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTick, (float)livingEntity.field_184618_aE, (float)livingEntity.field_70721_aZ);
            limbSwing = livingEntity.field_184619_aG - livingEntity.field_70721_aZ * (1.0f - partialTick);
            if (livingEntity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender) {
            float headPitch = MathHelper.func_219799_g((float)partialTick, (float)((Entity)animatable).field_70127_C, (float)((Entity)animatable).field_70125_A);
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            Vec3d velocity = animatable.func_213322_ci();
            float avgVelocity = (float)(Math.abs(velocity.field_72450_a) + Math.abs(velocity.field_72449_c) / 2.0);
            AnimationState<GeoAnimatable> animationState = new AnimationState<GeoAnimatable>((GeoAnimatable)animatable, limbSwing, limbSwingAmount, partialTick, avgVelocity >= motionThreshold && limbSwingAmount != 0.0f);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
            animationState.setData(DataTickets.ENTITY, animatable);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.func_70631_g_(), -netHeadYaw, -headPitch));
            this.model.addAdditionalStateData((Entity)((GeoAnimatable)animatable), instanceId, (BiConsumer<DataTicket<Entity>, Entity>)((BiConsumer<DataTicket, Entity>)(x$0, x$1) -> animationState.setData(x$0, x$1)));
            this.model.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        poseStack.func_227861_a_(0.0, (double)0.01f, 0.0);
        this.modelRenderTranslations = new Matrix4f(poseStack.func_227866_c_().func_227870_a_());
        assert (Minecraft.func_71410_x().field_71439_g != null);
        if (!animatable.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            GeoRenderer.super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.func_227865_b_();
    }

    @Override
    public void applyRenderLayers(MatrixStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!animatable.func_175149_v()) {
            GeoRenderer.super.applyRenderLayers(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
    }

    @Override
    public void renderFinal(MatrixStack poseStack, T animatable, BakedGeoModel model, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Entity leashHolder;
        super.func_225623_a_(animatable, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        if (animatable instanceof MobEntity && (leashHolder = ((MobEntity)animatable).func_110166_bE()) != null) {
            this.renderLeash((MobEntity)animatable, partialTick, poseStack, bufferSource, leashHolder);
        }
    }

    @Override
    public void renderRecursively(MatrixStack poseStack, T animatable, GeoBone bone, RenderType renderType, IRenderTypeBuffer bufferSource, IVertexBuilder buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.func_227860_a_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = poseStack.func_227866_c_().func_227870_a_().func_226601_d_();
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            localMatrix.func_226597_a_(new Vector3f(this.func_225627_b_((Entity)this.animatable, 1.0f)));
            bone.setLocalSpaceMatrix(localMatrix);
            Matrix4f worldState = localMatrix.func_226601_d_();
            worldState.func_226597_a_(new Vector3f(this.animatable.func_213303_ch()));
            bone.setWorldSpaceMatrix(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (!isReRender && buffer instanceof BufferBuilder && !((BufferBuilder)buffer).field_179010_r) {
            buffer = bufferSource.getBuffer(renderType);
        }
        this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.func_227865_b_();
    }

    protected void applyRotations(T animatable, MatrixStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        this.applyRotations(animatable, poseStack, ageInTicks, rotationYaw, partialTick, 1.0f);
    }

    protected void applyRotations(T animatable, MatrixStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (this.isShaking(animatable)) {
            rotationYaw += (float)(Math.cos((double)((Entity)animatable).field_70173_aa * 3.25) * Math.PI * 0.4);
        }
        if (animatable.func_213283_Z() != Pose.SLEEPING) {
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        if (animatable instanceof LivingEntity) {
            if (((LivingEntity)animatable).field_70725_aQ > 0) {
                float deathRotation = ((float)((LivingEntity)animatable).field_70725_aQ + partialTick - 1.0f) / 20.0f * 1.6f;
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(Math.min(MathHelper.func_76129_c((float)deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
            } else if (((LivingEntity)animatable).func_204805_cN()) {
                poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - ((Entity)animatable).field_70125_A));
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)((Entity)animatable).field_70173_aa + partialTick) * -75.0f));
            } else if (animatable.func_213283_Z() == Pose.SLEEPING) {
                Direction bedOrientation = ((LivingEntity)animatable).func_213376_dz();
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.getDeathMaxRotation(animatable)));
                poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
            } else if (GeoEntityRenderer.isEntityUpsideDown((LivingEntity)animatable)) {
                poseStack.func_227861_a_(0.0, (double)((animatable.func_213302_cg() + 0.1f) / nativeScale), 0.0);
                poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            }
        }
    }

    public static boolean isEntityUpsideDown(LivingEntity livingEntity) {
        String s;
        if ((livingEntity instanceof PlayerEntity || livingEntity.func_145818_k_()) && ("Dinnerbone".equals(s = TextFormatting.func_110646_a((String)livingEntity.func_200200_C_().getString())) || "Grumm".equals(s))) {
            return !(livingEntity instanceof PlayerEntity) || ((PlayerEntity)livingEntity).func_175148_a(PlayerModelPart.CAPE);
        }
        return false;
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public boolean func_177070_b(T animatable) {
        double nameRenderDistance;
        double d = nameRenderDistance = animatable.func_226273_bm_() ? 32.0 : 64.0;
        if (!(animatable instanceof LivingEntity)) {
            return false;
        }
        if (this.field_76990_c.func_229099_b_(animatable) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        if (!(!(animatable instanceof MobEntity) || animatable.func_94059_bO() || animatable.func_145818_k_() && animatable == this.field_76990_c.field_147941_i)) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        assert (minecraft.field_71439_g != null);
        boolean visibleToClient = !animatable.func_98034_c((PlayerEntity)minecraft.field_71439_g);
        Team entityTeam = animatable.func_96124_cp();
        if (entityTeam == null) {
            return Minecraft.func_71382_s() && animatable != minecraft.func_175606_aa() && visibleToClient && !animatable.func_184207_aI();
        }
        Team playerTeam = minecraft.field_71439_g.func_96124_cp();
        if (entityTeam.func_178770_i() == Team.Visible.ALWAYS) {
            return visibleToClient;
        }
        if (entityTeam.func_178770_i() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
            return playerTeam == null ? visibleToClient : entityTeam.func_142054_a(playerTeam) && (entityTeam.func_98297_h() || visibleToClient);
        }
        if (entityTeam.func_178770_i() == Team.Visible.HIDE_FOR_OWN_TEAM) {
            return playerTeam == null ? visibleToClient : !entityTeam.func_142054_a(playerTeam) && visibleToClient;
        }
        return false;
    }

    public ResourceLocation func_110775_a(T entity) {
        return this.getTextureLocation(entity);
    }

    @Override
    public int getPackedOverlay(T animatable, float u) {
        if (!(animatable instanceof LivingEntity)) {
            return OverlayTexture.field_229196_a_;
        }
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)u), (int)OverlayTexture.func_229202_a_((((LivingEntity)animatable).field_70737_aN > 0 || ((LivingEntity)animatable).field_70725_aQ > 0 ? 1 : 0) != 0));
    }

    @Override
    public int getPackedOverlay(T animatable, float u, float partialTick) {
        return this.getPackedOverlay(animatable, u);
    }

    public <E extends Entity, M extends MobEntity> void renderLeash(M mob, float partialTick, MatrixStack poseStack, IRenderTypeBuffer bufferSource, E leashHolder) {
        int segment;
        poseStack.func_227860_a_();
        double d0 = MathHelper.func_219799_g((float)(partialTick * 0.5f), (float)leashHolder.field_70177_z, (float)leashHolder.field_70126_B) * ((float)Math.PI / 180);
        double d1 = MathHelper.func_219799_g((float)(partialTick * 0.5f), (float)leashHolder.field_70125_A, (float)leashHolder.field_70127_C) * ((float)Math.PI / 180);
        double d2 = Math.cos(d0);
        double d3 = Math.sin(d0);
        double d4 = Math.sin(d1);
        if (leashHolder instanceof HangingEntity) {
            d2 = 0.0;
            d3 = 0.0;
            d4 = -1.0;
        }
        double d5 = Math.cos(d1);
        double d6 = MathHelper.func_219803_d((double)partialTick, (double)leashHolder.field_70169_q, (double)leashHolder.func_226277_ct_()) - d2 * 0.7 - d3 * 0.5 * d5;
        double d7 = MathHelper.func_219803_d((double)partialTick, (double)(leashHolder.field_70167_r + (double)leashHolder.func_70047_e() * 0.7), (double)(leashHolder.func_226278_cu_() + (double)leashHolder.func_70047_e() * 0.7)) - d4 * 0.5 - 0.25;
        double d8 = MathHelper.func_219803_d((double)partialTick, (double)leashHolder.field_70166_s, (double)leashHolder.func_226281_cx_()) - d3 * 0.7 + d2 * 0.5 * d5;
        double d9 = (double)(MathHelper.func_219799_g((float)partialTick, (float)mob.field_70761_aq, (float)mob.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        d2 = Math.cos(d9) * (double)mob.func_213311_cf() * 0.4;
        d3 = Math.sin(d9) * (double)mob.func_213311_cf() * 0.4;
        double d10 = MathHelper.func_219803_d((double)partialTick, (double)mob.field_70169_q, (double)mob.func_226277_ct_()) + d2;
        double d11 = MathHelper.func_219803_d((double)partialTick, (double)mob.field_70167_r, (double)mob.func_226278_cu_());
        double d12 = MathHelper.func_219803_d((double)partialTick, (double)mob.field_70166_s, (double)mob.func_226281_cx_()) + d3;
        poseStack.func_227861_a_(d2, -(1.6 - (double)mob.func_213302_cg()) * 0.5, d3);
        float f = (float)(d6 - d10);
        float f1 = (float)(d7 - d11);
        float f2 = (float)(d8 - d12);
        IVertexBuilder ivertexbuilder = bufferSource.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        int i = this.func_225624_a_((Entity)this.animatable, partialTick);
        int j = this.func_225624_a_(leashHolder, partialTick);
        int k = mob.field_70170_p.func_226658_a_(LightType.SKY, new BlockPos(mob.func_174824_e(partialTick)));
        int l = mob.field_70170_p.func_226658_a_(LightType.SKY, new BlockPos(leashHolder.func_174824_e(partialTick)));
        for (segment = 0; segment <= 24; ++segment) {
            GeoEntityRenderer.renderLeashPiece(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.025f, f5, f6, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoEntityRenderer.renderLeashPiece(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.025f, f5, f6, segment, true);
        }
        poseStack.func_227865_b_();
    }

    protected int func_225624_a_(Entity entityIn, float partialTicks) {
        return entityIn.func_70027_ad() ? 15 : entityIn.field_70170_p.func_226658_a_(LightType.BLOCK, new BlockPos(entityIn.func_174824_e(partialTicks)));
    }

    private static void renderLeashPiece(IVertexBuilder buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)MathHelper.func_219799_g((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.func_228451_a_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.func_227888_a_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
        buffer.func_227888_a_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).func_227885_a_(red, green, blue, 1.0f).func_227886_a_(packedLight).func_181675_d();
    }

    public boolean isShaking(T entity) {
        return false;
    }
}

